/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchema_;
import org.dspace.content.dao.MetadataSchemaDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class MetadataSchemaDAOImpl
extends AbstractHibernateDAO<MetadataSchema>
implements MetadataSchemaDAO {
    protected MetadataSchemaDAOImpl() {
    }

    @Override
    public MetadataSchema findByNamespace(Context context, String namespace) throws SQLException {
        Query query = this.createQuery(context, "SELECT ms FROM MetadataSchema ms WHERE ms.namespace = :namespace ");
        query.setParameter("namespace", (Object)namespace);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return (MetadataSchema)this.singleResult(query);
    }

    @Override
    public List<MetadataSchema> findAll(Context context, Class clazz) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MetadataSchema> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MetadataSchema.class);
        Root metadataSchemaRoot = criteriaQuery.from(MetadataSchema.class);
        criteriaQuery.select((Selection)metadataSchemaRoot);
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)metadataSchemaRoot.get(MetadataSchema_.id)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, true, MetadataSchema.class, -1, -1);
    }

    @Override
    public boolean uniqueNamespace(Context context, int metadataSchemaId, String namespace) throws SQLException {
        Query query = this.createQuery(context, "SELECT ms FROM MetadataSchema ms WHERE ms.namespace = :namespace and ms.id != :id");
        query.setParameter("namespace", (Object)namespace);
        query.setParameter("id", (Object)metadataSchemaId);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.singleResult(query) == null;
    }

    @Override
    public boolean uniqueShortName(Context context, int metadataSchemaId, String name) throws SQLException {
        Query query = this.createQuery(context, "SELECT ms FROM MetadataSchema ms WHERE ms.name = :name and ms.id != :id");
        query.setParameter("name", (Object)name);
        query.setParameter("id", (Object)metadataSchemaId);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.singleResult(query) == null;
    }

    @Override
    public MetadataSchema find(Context context, String shortName) throws SQLException {
        Query query = this.createQuery(context, "SELECT ms FROM MetadataSchema ms WHERE ms.name = :name");
        query.setParameter("name", (Object)shortName);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return (MetadataSchema)this.singleResult(query);
    }
}

