/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.BitstreamFormat_;
import org.dspace.content.dao.BitstreamFormatDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class BitstreamFormatDAOImpl
extends AbstractHibernateDAO<BitstreamFormat>
implements BitstreamFormatDAO {
    protected BitstreamFormatDAOImpl() {
    }

    @Override
    public BitstreamFormat findByMIMEType(Context context, String mimeType, boolean includeInternal) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BitstreamFormat> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BitstreamFormat.class);
        Root bitstreamFormatRoot = criteriaQuery.from(BitstreamFormat.class);
        criteriaQuery.select((Selection)bitstreamFormatRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)bitstreamFormatRoot.get(BitstreamFormat_.internal), (Object)includeInternal), (Expression)criteriaBuilder.like((Expression)bitstreamFormatRoot.get(BitstreamFormat_.mimetype), mimeType)));
        return (BitstreamFormat)this.singleResult(context, criteriaQuery);
    }

    @Override
    public BitstreamFormat findByShortDescription(Context context, String desc) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BitstreamFormat> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BitstreamFormat.class);
        Root bitstreamFormatRoot = criteriaQuery.from(BitstreamFormat.class);
        criteriaQuery.select((Selection)bitstreamFormatRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)bitstreamFormatRoot.get(BitstreamFormat_.shortDescription), (Object)desc));
        return this.uniqueResult(context, criteriaQuery, false, BitstreamFormat.class);
    }

    @Override
    public int updateRemovedBitstreamFormat(Context context, BitstreamFormat deletedBitstreamFormat, BitstreamFormat newBitstreamFormat) throws SQLException {
        Query query = this.createQuery(context, "update Bitstream set bitstreamFormat = :unknown_format where bitstreamFormat = :deleted_format");
        query.setParameter("unknown_format", (Object)newBitstreamFormat);
        query.setParameter("deleted_format", (Object)deletedBitstreamFormat);
        return query.executeUpdate();
    }

    @Override
    public List<BitstreamFormat> findNonInternal(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BitstreamFormat> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BitstreamFormat.class);
        Root bitstreamFormatRoot = criteriaQuery.from(BitstreamFormat.class);
        criteriaQuery.select((Selection)bitstreamFormatRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)bitstreamFormatRoot.get(BitstreamFormat_.internal), (Object)false), (Expression)criteriaBuilder.not((Expression)criteriaBuilder.like((Expression)bitstreamFormatRoot.get(BitstreamFormat_.shortDescription), "Unknown"))));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)bitstreamFormatRoot.get(BitstreamFormat_.supportLevel)));
        orderList.add(criteriaBuilder.asc((Expression)bitstreamFormatRoot.get(BitstreamFormat_.shortDescription)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, BitstreamFormat.class, -1, -1);
    }

    @Override
    public List<BitstreamFormat> findByFileExtension(Context context, String extension) throws SQLException {
        Query query = this.createQuery(context, "from BitstreamFormat bf where :extension in elements(bf.fileExtensions)");
        query.setParameter("extension", (Object)extension);
        return this.list(query);
    }

    @Override
    public List<BitstreamFormat> findAll(Context context, Class clazz) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<BitstreamFormat> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, BitstreamFormat.class);
        Root bitstreamFormatRoot = criteriaQuery.from(BitstreamFormat.class);
        criteriaQuery.select((Selection)bitstreamFormatRoot);
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)bitstreamFormatRoot.get(BitstreamFormat_.id)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, BitstreamFormat.class, -1, -1);
    }
}

