/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.util.UUIDUtils;
import org.dspace.web.ContextUtil;

public class EPersonAuthority
implements ChoiceAuthority {
    private static final Logger log = LogManager.getLogger(EPersonAuthority.class);
    private String authorityName;
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    @Override
    public Choices getBestMatch(String text, String locale) {
        return this.getMatches(text, 0, 2, locale);
    }

    @Override
    public Choices getMatches(String text, int start, int limit, String locale) {
        if (limit <= 0) {
            limit = 20;
        }
        Context context = this.getContext();
        List<EPerson> ePersons = this.searchEPersons(context, text, start, limit);
        ArrayList<Choice> choiceList = new ArrayList<Choice>();
        for (EPerson eperson : ePersons) {
            choiceList.add(new Choice(eperson.getID().toString(), eperson.getFullName(), eperson.getFullName()));
        }
        Choice[] results = new Choice[choiceList.size()];
        results = choiceList.toArray(results);
        return new Choices(results, start, ePersons.size(), 400, ePersons.size() > start + limit, 0);
    }

    @Override
    public String getLabel(String key, String locale) {
        UUID uuid = UUIDUtils.fromString(key);
        if (uuid == null) {
            return null;
        }
        Context context = this.getContext();
        try {
            EPerson ePerson = (EPerson)this.ePersonService.find(context, uuid);
            return ePerson != null ? ePerson.getFullName() : null;
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private List<EPerson> searchEPersons(Context context, String text, int start, int limit) {
        if (!this.isCurrentUserAdminOrAccessGroupManager(context)) {
            return Collections.emptyList();
        }
        try {
            return this.ePersonService.search(context, text, start, limit);
        }
        catch (SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Context getContext() {
        Context context = ContextUtil.obtainCurrentRequestContext();
        return context != null ? context : new Context();
    }

    private boolean isCurrentUserAdminOrAccessGroupManager(Context context) {
        try {
            return this.authorizeService.isAdmin(context) || this.authorizeService.isAccountManager(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPluginInstanceName() {
        return this.authorityName;
    }

    @Override
    public void setPluginInstanceName(String name) {
        this.authorityName = name;
    }
}

