/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;

public class FixDefaultPolicies {
    private FixDefaultPolicies() {
    }

    public static void main(String[] argv) throws Exception {
        Context c = new Context();
        c.turnOffAuthorisationSystem();
        ContentServiceFactory contentServiceFactory = ContentServiceFactory.getInstance();
        List<Collection> collections = contentServiceFactory.getCollectionService().findAll(c);
        for (Collection t : collections) {
            System.out.println("Collection " + t + " " + t.getName());
            if (FixDefaultPolicies.checkForPolicy(c, t, 0)) {
                System.out.println("\tFound READ policies!");
            } else {
                System.out.println("\tNo READ policy found, adding anonymous.");
                FixDefaultPolicies.addAnonymousPolicy(c, t, 0);
            }
            if (FixDefaultPolicies.checkForPolicy(c, t, 10)) {
                System.out.println("\tFound DEFAULT_ITEM_READ policies!");
            } else {
                System.out.println("\tNo DEFAULT_ITEM_READ policy found, adding anonymous.");
                FixDefaultPolicies.addAnonymousPolicy(c, t, 10);
            }
            if (FixDefaultPolicies.checkForPolicy(c, t, 9)) {
                System.out.println("\tFound DEFAULT_BITSTREAM_READ policies!");
                continue;
            }
            System.out.println("\tNo DEFAULT_BITSTREAM_READ policy found, adding anonymous.");
            FixDefaultPolicies.addAnonymousPolicy(c, t, 9);
        }
        List<Community> communities = contentServiceFactory.getCommunityService().findAll(c);
        for (Community t : communities) {
            System.out.println("Community " + t + " " + t.getName());
            if (FixDefaultPolicies.checkForPolicy(c, t, 0)) {
                System.out.println("\tFound READ policies!");
                continue;
            }
            System.out.println("\tNo READ policy found, adding anonymous.");
            FixDefaultPolicies.addAnonymousPolicy(c, t, 0);
        }
        c.complete();
        System.exit(0);
    }

    private static boolean checkForPolicy(Context c, DSpaceObject t, int myaction) throws SQLException {
        List<ResourcePolicy> policies = AuthorizeServiceFactory.getInstance().getAuthorizeService().getPoliciesActionFilter(c, t, myaction);
        return policies.size() > 0;
    }

    private static void addAnonymousPolicy(Context c, DSpaceObject t, int myaction) throws SQLException, AuthorizeException {
        Group anonymousGroup = EPersonServiceFactory.getInstance().getGroupService().findByName(c, "Anonymous");
        ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
        ResourcePolicy myPolicy = resourcePolicyService.create(c, null, anonymousGroup);
        myPolicy.setdSpaceObject(t);
        myPolicy.setAction(myaction);
        resourcePolicyService.update(c, myPolicy);
    }
}

