/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnumUtils {
    private static Logger log = LogManager.getLogger(EnumUtils.class);

    private EnumUtils() {
    }

    private static String getEnumName(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? value.toUpperCase().trim().replaceAll("[^a-zA-Z]", "_") : null;
    }

    public static <E extends Enum<E>> E lookup(Class<E> enumClass, String enumName) {
        try {
            return Enum.valueOf(enumClass, EnumUtils.getEnumName(enumName));
        }
        catch (Exception ex) {
            log.warn("Did not find an " + enumClass.getSimpleName() + " for value '" + enumName + "'");
            return null;
        }
    }
}

