/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemSubmitterStrategy;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;

public class RequestItemMetadataStrategy
extends RequestItemSubmitterStrategy {
    protected String emailMetadata;
    protected String fullNameMetadata;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    @NonNull
    public List<RequestItemAuthor> getRequestItemAuthor(Context context, Item item) throws SQLException {
        if (this.emailMetadata != null) {
            boolean useNames;
            List<MetadataValue> vals = this.itemService.getMetadataByMetadataString(item, this.emailMetadata);
            List<MetadataValue> nameVals = null != this.fullNameMetadata ? this.itemService.getMetadataByMetadataString(item, this.fullNameMetadata) : Collections.EMPTY_LIST;
            boolean bl = useNames = vals.size() == nameVals.size();
            if (!vals.isEmpty()) {
                ArrayList<RequestItemAuthor> authors = new ArrayList<RequestItemAuthor>(vals.size());
                for (int authorIndex = 0; authorIndex < vals.size(); ++authorIndex) {
                    String email = vals.get(authorIndex).getValue();
                    String fullname = null;
                    if (useNames) {
                        fullname = nameVals.get(authorIndex).getValue();
                    }
                    if (StringUtils.isBlank(fullname)) {
                        fullname = I18nUtil.getMessage("org.dspace.app.requestitem.RequestItemMetadataStrategy.unnamed", context);
                    }
                    RequestItemAuthor author = new RequestItemAuthor(fullname, email);
                    authors.add(author);
                }
                return authors;
            }
            return Collections.EMPTY_LIST;
        }
        List<RequestItemAuthor> authors = super.getRequestItemAuthor(context, item);
        for (RequestItemAuthor author : authors) {
            if (null != author.getEmail()) continue;
            authors.remove(author);
        }
        if (authors.isEmpty()) {
            String email = this.configurationService.getProperty("mail.helpdesk");
            String name = this.configurationService.getProperty("mail.helpdesk.name");
            if (email == null) {
                email = this.configurationService.getProperty("mail.admin");
                name = this.configurationService.getProperty("mail.admin.name");
            }
            authors.add(new RequestItemAuthor(name, email));
        }
        return authors;
    }

    public void setEmailMetadata(@NonNull String emailMetadata) {
        this.emailMetadata = emailMetadata;
    }

    public void setFullNameMetadata(@NonNull String fullNameMetadata) {
        this.fullNameMetadata = fullNameMetadata;
    }
}

