/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.app.mediafilter.FormatFilter;
import org.dspace.app.mediafilter.MediaFilterScriptConfiguration;
import org.dspace.app.mediafilter.factory.MediaFilterServiceFactory;
import org.dspace.app.mediafilter.service.MediaFilterService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;

public class MediaFilterScript
extends DSpaceRunnable<MediaFilterScriptConfiguration> {
    private static final String MEDIA_FILTER_PLUGINS_KEY = "filter.plugins";
    private static final String FILTER_PREFIX = "filter";
    private static final String INPUT_FORMATS_SUFFIX = "inputFormats";
    private boolean help;
    private boolean isVerbose = false;
    private boolean isQuiet = false;
    private boolean isForce = false;
    private String identifier = null;
    private int max2Process = Integer.MAX_VALUE;
    private String[] filterNames;
    private String[] skipIds = null;
    private Map<String, List<String>> filterFormats = new HashMap<String, List<String>>();

    @Override
    public MediaFilterScriptConfiguration getScriptConfiguration() {
        return (MediaFilterScriptConfiguration)new DSpace().getServiceManager().getServiceByName("filter-media", MediaFilterScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        System.setProperty("java.awt.headless", "true");
        this.help = this.commandLine.hasOption('h');
        if (this.commandLine.hasOption('v')) {
            this.isVerbose = true;
        }
        this.isQuiet = this.commandLine.hasOption('q');
        if (this.commandLine.hasOption('f')) {
            this.isForce = true;
        }
        if (this.commandLine.hasOption('i')) {
            this.identifier = this.commandLine.getOptionValue('i');
        }
        if (this.commandLine.hasOption('m')) {
            this.max2Process = Integer.parseInt(this.commandLine.getOptionValue('m'));
            if (this.max2Process <= 1) {
                this.handler.logWarning("Invalid maximum value '" + this.commandLine.getOptionValue('m') + "' - ignoring");
                this.max2Process = Integer.MAX_VALUE;
            }
        }
        this.filterNames = this.commandLine.hasOption('p') ? this.commandLine.getOptionValues('p') : DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty(MEDIA_FILTER_PLUGINS_KEY);
        if (this.commandLine.hasOption('s')) {
            this.skipIds = this.commandLine.getOptionValues('s');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.printHelp();
            return;
        }
        MediaFilterService mediaFilterService = MediaFilterServiceFactory.getInstance().getMediaFilterService();
        mediaFilterService.setLogHandler(this.handler);
        mediaFilterService.setForce(this.isForce);
        mediaFilterService.setQuiet(this.isQuiet);
        mediaFilterService.setVerbose(this.isVerbose);
        mediaFilterService.setMax2Process(this.max2Process);
        ArrayList<FormatFilter> filterList = new ArrayList<FormatFilter>();
        for (int i = 0; i < this.filterNames.length; ++i) {
            Object[] formats;
            FormatFilter filter = (FormatFilter)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(FormatFilter.class, this.filterNames[i]);
            if (filter == null) {
                this.handler.handleException("ERROR: Unknown MediaFilter specified (either from command-line or in dspace.cfg): '" + this.filterNames[i] + "'");
                this.handler.logError("ERROR: Unknown MediaFilter specified (either from command-line or in dspace.cfg): '" + this.filterNames[i] + "'");
                continue;
            }
            filterList.add(filter);
            String filterClassName = filter.getClass().getName();
            String pluginName = null;
            if (SelfNamedPlugin.class.isAssignableFrom(filter.getClass())) {
                pluginName = ((SelfNamedPlugin)((Object)filter)).getPluginInstanceName();
            }
            if (!ArrayUtils.isNotEmpty((Object[])(formats = DSpaceServicesFactory.getInstance().getConfigurationService().getArrayProperty("filter." + filterClassName + (String)(pluginName != null ? "." + pluginName : "") + ".inputFormats")))) continue;
            this.filterFormats.put(filterClassName + (String)(pluginName != null ? "\u001c" + pluginName : ""), Arrays.asList(formats));
        }
        if (this.isVerbose) {
            this.handler.logInfo("The following MediaFilters are enabled: ");
            for (String filterName : this.filterFormats.keySet()) {
                this.handler.logInfo("Full Filter Name: " + filterName);
                String pluginName = null;
                if (filterName.contains("\u001c")) {
                    String[] fields = filterName.split("\u001c");
                    filterName = fields[0];
                    pluginName = fields[1];
                }
                this.handler.logInfo(filterName + (String)(pluginName != null ? " (Plugin: " + pluginName + ")" : ""));
            }
        }
        mediaFilterService.setFilterFormats(this.filterFormats);
        mediaFilterService.setFilterClasses(filterList);
        if (this.skipIds != null && this.skipIds.length > 0) {
            mediaFilterService.setSkipList(Arrays.asList(this.skipIds));
        }
        Context c = null;
        try {
            c = new Context();
            c.turnOffAuthorisationSystem();
            if (this.identifier == null) {
                mediaFilterService.applyFiltersAllItems(c);
            } else {
                DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(c, this.identifier);
                if (dso == null) {
                    throw new IllegalArgumentException("Cannot resolve " + this.identifier + " to a DSpace object");
                }
                switch (dso.getType()) {
                    case 4: {
                        mediaFilterService.applyFiltersCommunity(c, (Community)dso);
                        break;
                    }
                    case 3: {
                        mediaFilterService.applyFiltersCollection(c, (Collection)dso);
                        break;
                    }
                    case 2: {
                        mediaFilterService.applyFiltersItem(c, (Item)dso);
                        break;
                    }
                }
            }
            c.complete();
            c = null;
        }
        catch (Exception e) {
            this.handler.handleException(e);
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
    }
}

