/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemmarking;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.app.itemmarking.ItemMarkingExtractor;
import org.dspace.app.itemmarking.ItemMarkingInfo;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemMarkingMetadataStrategy
implements ItemMarkingExtractor {
    @Autowired(required=true)
    protected ItemService itemService;
    private String metadataField;
    Map<String, ItemMarkingInfo> mapping = new HashMap<String, ItemMarkingInfo>();

    @Override
    public ItemMarkingInfo getItemMarkingInfo(Context context, Item item) throws SQLException {
        List<MetadataValue> vals;
        if (this.metadataField != null && this.mapping != null && (vals = this.itemService.getMetadataByMetadataString(item, this.metadataField)).size() > 0) {
            for (MetadataValue value : vals) {
                String type = value.getValue();
                if (!this.mapping.containsKey(type)) continue;
                return this.mapping.get(type);
            }
        }
        return null;
    }

    public void setMetadataField(String metadataField) {
        this.metadataField = metadataField;
    }

    public void setMapping(Map<String, ItemMarkingInfo> mapping) {
        this.mapping = mapping;
    }
}

