/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExportSearchScriptConfiguration;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.MetadataDSpaceCsvExportServiceImpl;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.MetadataDSpaceCsvExportService;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableCommunity;
import org.dspace.discovery.indexobject.IndexableDSpaceObject;
import org.dspace.discovery.utils.DiscoverQueryBuilder;
import org.dspace.discovery.utils.parameter.QueryBuilderSearchFilter;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class MetadataExportSearch
extends DSpaceRunnable<MetadataExportSearchScriptConfiguration> {
    private static final String EXPORT_CSV = "exportCSV";
    private boolean help = false;
    private String identifier;
    private String discoveryConfigName;
    private String[] filterQueryStrings;
    private boolean hasScope = false;
    private String query;
    private SearchService searchService;
    private MetadataDSpaceCsvExportService metadataDSpaceCsvExportService;
    private EPersonService ePersonService;
    private DiscoveryConfigurationService discoveryConfigurationService;
    private CommunityService communityService;
    private CollectionService collectionService;
    private DiscoverQueryBuilder queryBuilder;

    @Override
    public MetadataExportSearchScriptConfiguration getScriptConfiguration() {
        return (MetadataExportSearchScriptConfiguration)new DSpace().getServiceManager().getServiceByName("metadata-export-search", MetadataExportSearchScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.searchService = SearchUtils.getSearchService();
        this.metadataDSpaceCsvExportService = (MetadataDSpaceCsvExportService)new DSpace().getServiceManager().getServiceByName(MetadataDSpaceCsvExportServiceImpl.class.getCanonicalName(), MetadataDSpaceCsvExportService.class);
        this.ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        this.discoveryConfigurationService = SearchUtils.getConfigurationService();
        this.communityService = ContentServiceFactory.getInstance().getCommunityService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        this.queryBuilder = SearchUtils.getQueryBuilder();
        if (this.commandLine.hasOption('h')) {
            this.help = true;
            return;
        }
        if (this.commandLine.hasOption('q')) {
            this.query = this.commandLine.getOptionValue('q');
        }
        if (this.commandLine.hasOption('s')) {
            this.hasScope = true;
            this.identifier = this.commandLine.getOptionValue('s');
        }
        if (this.commandLine.hasOption('c')) {
            this.discoveryConfigName = this.commandLine.getOptionValue('c');
        }
        if (this.commandLine.hasOption('f')) {
            this.filterQueryStrings = this.commandLine.getOptionValues('f');
        }
    }

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.loghelpinfo();
            this.printHelp();
            return;
        }
        this.handler.logDebug("starting search export");
        IndexableObject dso = null;
        Context context = new Context();
        context.setCurrentUser((EPerson)this.ePersonService.find(context, this.getEpersonIdentifier()));
        if (this.hasScope) {
            dso = this.resolveScope(context, this.identifier);
        }
        DiscoveryConfiguration discoveryConfiguration = this.discoveryConfigurationService.getDiscoveryConfiguration(this.discoveryConfigName);
        ArrayList<QueryBuilderSearchFilter> queryBuilderSearchFilters = new ArrayList<QueryBuilderSearchFilter>();
        this.handler.logDebug("processing filter queries");
        if (this.filterQueryStrings != null) {
            for (String filterQueryString : this.filterQueryStrings) {
                String field = filterQueryString.split(",", 2)[0];
                String operator = filterQueryString.split("(,|=)", 3)[1];
                String value = filterQueryString.split("=", 2)[1];
                QueryBuilderSearchFilter queryBuilderSearchFilter = new QueryBuilderSearchFilter(field, operator, value);
                queryBuilderSearchFilters.add(queryBuilderSearchFilter);
            }
        }
        this.handler.logDebug("building query");
        DiscoverQuery discoverQuery = this.queryBuilder.buildQuery(context, dso, discoveryConfiguration, this.query, queryBuilderSearchFilters, "Item", (Integer)10, Long.getLong("0"), null, "DESC");
        this.handler.logDebug("creating iterator");
        Iterator<Item> itemIterator = this.searchService.iteratorSearch(context, dso, discoverQuery);
        this.handler.logDebug("creating dspacecsv");
        DSpaceCSV dSpaceCSV = this.metadataDSpaceCsvExportService.export(context, itemIterator, true, this.handler);
        this.handler.logDebug("writing to file " + this.getFileNameOrExportFile());
        this.handler.writeFilestream(context, this.getFileNameOrExportFile(), dSpaceCSV.getInputStream(), EXPORT_CSV);
        context.restoreAuthSystemState();
        context.complete();
    }

    protected void loghelpinfo() {
        this.handler.logInfo("metadata-export");
    }

    protected String getFileNameOrExportFile() {
        return "metadataExportSearch.csv";
    }

    public IndexableObject resolveScope(Context context, String id) throws SQLException {
        UUID uuid = UUID.fromString(id);
        IndexableDSpaceObject scopeObj = new IndexableCommunity((Community)this.communityService.find(context, uuid));
        if (scopeObj.getIndexedObject() == null) {
            scopeObj = new IndexableCollection((Collection)this.collectionService.find(context, uuid));
        }
        return scopeObj;
    }
}

