/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkaccesscontrol;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.bulkaccesscontrol.BulkAccessControl;
import org.dspace.app.bulkaccesscontrol.BulkAccessControlScriptConfiguration;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.scripts.DSpaceCommandLineParameter;

public class BulkAccessControlCli
extends BulkAccessControl {
    @Override
    protected void setEPerson(Context context) throws SQLException {
        this.eperson = this.commandLine.getOptionValue('e');
        if (this.eperson == null) {
            this.handler.logError("An eperson to do the the Bulk Access Control must be specified (run with -h flag for details)");
            throw new UnsupportedOperationException("An eperson to do the Bulk Access Control must be specified");
        }
        EPerson myEPerson = StringUtils.contains((CharSequence)this.eperson, (int)64) ? this.epersonService.findByEmail(context, this.eperson) : (EPerson)this.epersonService.find(context, UUID.fromString(this.eperson));
        if (myEPerson == null) {
            this.handler.logError("EPerson cannot be found: " + this.eperson + " (run with -h flag for details)");
            throw new UnsupportedOperationException("EPerson cannot be found: " + this.eperson);
        }
        context.setCurrentUser(myEPerson);
    }

    @Override
    protected boolean isAuthorized(Context context) {
        if (context.getCurrentUser() == null) {
            return false;
        }
        return ((BulkAccessControlScriptConfiguration)this.getScriptConfiguration()).isAllowedToExecute(context, Arrays.stream(this.commandLine.getOptions()).map(option -> new DSpaceCommandLineParameter("-" + option.getOpt(), option.getValue())).collect(Collectors.toList()));
    }
}

