/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.web;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.utils.DSpace;

public class ContextUtil {
    private static final Logger log = LogManager.getLogger(ContextUtil.class);
    public static final String DSPACE_CONTEXT = "dspace.context";

    private ContextUtil() {
    }

    public static boolean isContextAvailable(ServletRequest request) {
        Object object = request.getAttribute(DSPACE_CONTEXT);
        return object instanceof Context;
    }

    public static Context obtainContext(HttpServletRequest request) {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context == null) {
            try {
                context = ContextUtil.initializeContext();
            }
            catch (SQLException e) {
                log.error("Unable to initialize context", (Throwable)e);
                return null;
            }
            request.setAttribute(DSPACE_CONTEXT, (Object)context);
        }
        Locale currentLocale = ContextUtil.getLocale(context, request);
        context.setCurrentLocale(currentLocale);
        return context;
    }

    public static Context obtainCurrentRequestContext() {
        Context context = null;
        RequestService requestService = new DSpace().getRequestService();
        Request currentRequest = requestService.getCurrentRequest();
        if (currentRequest != null) {
            context = ContextUtil.obtainContext(currentRequest.getHttpServletRequest());
        }
        return context;
    }

    private static Locale getLocale(Context context, HttpServletRequest request) {
        String userLanguage;
        Enumeration locales;
        Locale userLocale = null;
        Locale supportedLocale = null;
        String locale = request.getHeader("Accept-Language");
        if (StringUtils.isNotBlank((CharSequence)locale) && (locales = request.getLocales()) != null) {
            while (locales.hasMoreElements()) {
                Locale current = (Locale)locales.nextElement();
                if (!I18nUtil.isSupportedLocale(current)) continue;
                userLocale = current;
                break;
            }
        }
        if (userLocale == null && context.getCurrentUser() != null && (userLanguage = context.getCurrentUser().getLanguage()) != null) {
            userLocale = new Locale(userLanguage);
        }
        if (userLocale == null) {
            return I18nUtil.getDefaultLocale();
        }
        supportedLocale = I18nUtil.getSupportedLocale(userLocale);
        return supportedLocale;
    }

    private static Context initializeContext() throws SQLException {
        Context context = new Context();
        return context;
    }

    public static void completeContext(ServletRequest request) throws ServletException {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context != null && context.isValid()) {
            try {
                context.complete();
            }
            catch (SQLException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public static void abortContext(ServletRequest request) {
        Context context = (Context)request.getAttribute(DSPACE_CONTEXT);
        if (context != null && context.isValid()) {
            context.abort();
        }
    }
}

