/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.text.filter;

import org.dspace.text.filter.TextFilter;

public abstract class InitialArticleWord
implements TextFilter {
    private final String wordSeparator;
    private boolean stripInitialArticle = false;

    @Override
    public String filter(String str) {
        return this.filter(str, null);
    }

    @Override
    public String filter(String str, String lang) {
        String[] articleWordArr = this.getArticleWords(lang);
        if (articleWordArr != null && articleWordArr.length > 0) {
            String initialArticleWord = null;
            int initialStart = -1;
            int initialEnd = -1;
            for (int curPos = 0; initialEnd < 0 && curPos < str.length(); ++curPos) {
                if (!Character.isLetterOrDigit(str.charAt(curPos))) continue;
                initialStart = curPos;
                for (int idx = 0; initialEnd < 0 && idx < articleWordArr.length; ++idx) {
                    if (idx > 1 && initialArticleWord != null) {
                        if (initialArticleWord.length() != articleWordArr[idx].length()) {
                            initialArticleWord = this.extractText(str, curPos, articleWordArr[idx].length());
                        }
                    } else {
                        initialArticleWord = this.extractText(str, curPos, articleWordArr[idx].length());
                    }
                    if (initialArticleWord == null || !initialArticleWord.equalsIgnoreCase(articleWordArr[idx])) continue;
                    boolean isNextWhitespace = Character.isWhitespace(str.charAt(curPos + articleWordArr[idx].length()));
                    boolean endsLetterOrDigit = Character.isLetterOrDigit(initialArticleWord.charAt(initialArticleWord.length() - 1));
                    if (endsLetterOrDigit && isNextWhitespace) {
                        initialEnd = curPos + initialArticleWord.length();
                        continue;
                    }
                    if (endsLetterOrDigit) continue;
                    initialEnd = curPos + initialArticleWord.length();
                }
                break;
            }
            if (initialEnd > 0) {
                int cutPos;
                for (cutPos = initialEnd; cutPos < str.length() && Character.isWhitespace(str.charAt(cutPos)); ++cutPos) {
                }
                if (this.stripInitialArticle) {
                    return str.substring(cutPos);
                }
                return str.substring(cutPos) + this.wordSeparator + str.substring(initialStart, initialEnd);
            }
        }
        return str;
    }

    protected InitialArticleWord(boolean stripWord) {
        this.wordSeparator = ", ";
        this.stripInitialArticle = stripWord;
    }

    protected InitialArticleWord() {
        this.wordSeparator = ", ";
        this.stripInitialArticle = false;
    }

    protected abstract String[] getArticleWords(String var1);

    private String extractText(String str, int pos, int len) {
        int testPos;
        for (testPos = pos + len; testPos < str.length() && Character.isWhitespace(str.charAt(testPos)); ++testPos) {
        }
        if (testPos < str.length()) {
            return str.substring(pos, pos + len);
        }
        return null;
    }
}

