/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.model;

import java.util.List;
import javax.inject.Inject;
import org.dspace.services.ConfigurationService;
import org.dspace.submit.model.AccessConditionOption;

public class UploadConfiguration {
    private final ConfigurationService configurationService;
    private String metadataDefinition;
    private List<AccessConditionOption> options;
    private Long maxSize;
    private Boolean required;
    private String name;

    @Inject
    public UploadConfiguration(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public List<AccessConditionOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<AccessConditionOption> options) {
        this.options = options;
    }

    public String getMetadata() {
        return this.metadataDefinition;
    }

    public void setMetadata(String metadata) {
        this.metadataDefinition = metadata;
    }

    public Long getMaxSize() {
        if (this.maxSize == null) {
            this.maxSize = this.configurationService.getLongProperty("upload.max");
        }
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public Boolean isRequired() {
        if (this.required == null) {
            return this.configurationService.getBooleanProperty("webui.submit.upload.required", true);
        }
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

