/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.storage.rdbms.migration.MigrationUtils;
import org.flywaydb.core.Flyway;

public class FlywayUpgradeUtils {
    private static final Logger log = LogManager.getLogger(FlywayUpgradeUtils.class);
    private static final String UPGRADE_SCRIPT_PATH = "org/dspace/storage/rdbms/flywayupgrade/";

    private FlywayUpgradeUtils() {
    }

    protected static synchronized void upgradeFlywayTable(Flyway flyway, Connection connection) throws SQLException {
        boolean needsUpgrade = false;
        try {
            flyway.info();
        }
        catch (Exception e) {
            log.info("Flyway table '{}' appears to be outdated. Will attempt to upgrade it automatically. Flyway Exception was '{}'", (Object)"schema_version", (Object)e.toString());
            needsUpgrade = true;
        }
        if (needsUpgrade) {
            String lastMigration = DatabaseUtils.getCurrentFlywayState(connection);
            if (lastMigration.startsWith("5.")) {
                String dbtype = DatabaseUtils.getDbType(connection);
                String scriptPath = UPGRADE_SCRIPT_PATH + dbtype + "/upgradeToFlyway4x.sql";
                log.info("Attempting to upgrade Flyway table '{}' using script at '{}'", (Object)"schema_version", (Object)scriptPath);
                String flywayUpgradeSQL = MigrationUtils.getResourceAsString(scriptPath);
                HashMap<String, String> valuesMap = new HashMap<String, String>();
                valuesMap.put("schema", DatabaseUtils.getSchemaName(connection));
                valuesMap.put("table", "schema_version");
                StringSubstitutor sub = new StringSubstitutor(valuesMap);
                flywayUpgradeSQL = sub.replace(flywayUpgradeSQL);
                DatabaseUtils.executeSql(connection, flywayUpgradeSQL);
            }
            log.info("Repairing Flyway table '{}' after upgrade...", (Object)"schema_version");
            flyway.repair();
        }
    }
}

