/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.storage.bitstore.factory.StorageServiceFactory;

public class Cleanup {
    private static final Logger log = LogManager.getLogger(Cleanup.class);

    private Cleanup() {
    }

    public static void main(String[] argv) {
        try {
            log.info("Cleaning up asset store");
            DefaultParser parser = new DefaultParser();
            CommandLine line = null;
            Options options = new Options();
            options.addOption("l", "leave", false, "Leave database records but delete file from assetstore");
            options.addOption("v", "verbose", false, "Provide verbose output");
            options.addOption("h", "help", false, "Help");
            try {
                line = parser.parse(options, argv);
            }
            catch (ParseException e) {
                log.fatal((Object)e);
                System.exit(1);
            }
            if (line.hasOption('h')) {
                Cleanup.printHelp(options);
                System.exit(0);
            }
            boolean deleteDbRecords = true;
            if (line.hasOption('l')) {
                log.debug("option l used setting flag to leave db records");
                deleteDbRecords = false;
            }
            log.debug("leave db records = " + deleteDbRecords);
            StorageServiceFactory.getInstance().getBitstreamStorageService().cleanup(deleteDbRecords, line.hasOption('v'));
            System.exit(0);
        }
        catch (IOException | SQLException | AuthorizeException e) {
            log.fatal("Caught exception:", (Throwable)e);
            System.exit(1);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("Cleanup\n", options);
    }
}

