/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Utils;
import org.dspace.storage.bitstore.BitStoreService;
import org.dspace.storage.bitstore.DSBitStoreService;

public abstract class BaseBitStoreService
implements BitStoreService {
    protected static Logger log = LogManager.getLogger(DSBitStoreService.class);
    protected static final String CSA = "MD5";
    protected static final String MODIFIED = "modified";
    protected static final String CHECKSUM_ALGORITHM = "checksum_algorithm";
    protected static final String CHECKSUM = "checksum";
    protected static final String SIZE_BYTES = "size_bytes";
    protected boolean initialized = false;
    protected static final int digitsPerLevel = 2;
    protected static final int directoryLevels = 3;

    protected String getIntermediatePath(String internalId) {
        StringBuilder path = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)internalId) || internalId.length() <= 2) {
            return path.append(internalId).append(File.separator).toString();
        }
        this.populatePathSplittingId(internalId, path);
        this.appendSeparator(path);
        return path.toString();
    }

    protected String sanitizeIdentifier(String sInternalId) {
        if (sInternalId.contains(File.separator)) {
            sInternalId = sInternalId.substring(sInternalId.lastIndexOf(File.separator) + 1);
        }
        return sInternalId;
    }

    protected void appendSeparator(StringBuilder path) {
        if (!this.endsWithSeparator(path)) {
            path.append(File.separator);
        }
    }

    protected boolean endsWithSeparator(StringBuilder bufFilename) {
        return bufFilename.lastIndexOf(File.separator) == bufFilename.length() - 1;
    }

    protected void populatePathSplittingId(String internalId, StringBuilder path) {
        int digits = 0;
        path.append(this.extractSubstringFrom(internalId, digits, digits + 2));
        for (int i = 1; i < 3 && !this.isLonger(internalId, digits + 2); ++i) {
            digits = i * 2;
            path.append(File.separator);
            path.append(this.extractSubstringFrom(internalId, digits, digits + 2));
        }
    }

    protected String extractSubstringFrom(String internalId, int startIndex, int endIndex) {
        if (this.isLonger(internalId, endIndex)) {
            endIndex = internalId.length();
        }
        return internalId.substring(startIndex, endIndex);
    }

    protected boolean isLonger(String internalId, int endIndex) {
        return endIndex > internalId.length();
    }

    public Map<String, Object> about(File file, List<String> attrs) throws IOException {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        try {
            if (file != null && file.exists()) {
                this.putValueIfExistsKey(attrs, metadata, SIZE_BYTES, file.length());
                if (attrs.contains(CHECKSUM)) {
                    metadata.put(CHECKSUM, Utils.toHex(this.generateChecksumFrom(file)));
                    metadata.put(CHECKSUM_ALGORITHM, CSA);
                }
                this.putValueIfExistsKey(attrs, metadata, MODIFIED, String.valueOf(file.lastModified()));
            }
            return metadata;
        }
        catch (Exception e) {
            log.error("about( FilePath: " + file.getAbsolutePath() + ", Map: " + attrs.toString() + ")", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private byte[] generateChecksumFrom(File file) throws FileNotFoundException, IOException {
        byte[] byArray;
        FileInputStream fis = new FileInputStream(file);
        try {
            byArray = this.generateChecksumFrom(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("Caught NoSuchAlgorithmException", (Throwable)e);
                throw new IOException("Invalid checksum algorithm");
            }
        }
        fis.close();
        return byArray;
    }

    private byte[] generateChecksumFrom(FileInputStream fis) throws IOException, NoSuchAlgorithmException {
        try (DigestInputStream dis = new DigestInputStream(fis, MessageDigest.getInstance(CSA));){
            int count;
            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[4096];
            while ((count = dis.read(buffer, 0, 4096)) != -1) {
            }
            byte[] byArray = dis.getMessageDigest().digest();
            return byArray;
        }
    }

    protected void putValueIfExistsKey(List<String> attrs, Map<String, Object> metadata, String key, Object value) {
        if (attrs.contains(key)) {
            metadata.put(key, value);
        }
    }
}

