/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.IPTable;
import org.dspace.statistics.util.SpiderDetectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpiderDetectorServiceImpl
implements SpiderDetectorService {
    private static final Logger log = LoggerFactory.getLogger(SpiderDetectorServiceImpl.class);
    private Boolean useCaseInsensitiveMatching;
    private final List<Pattern> agents = Collections.synchronizedList(new ArrayList());
    private final List<Pattern> domains = Collections.synchronizedList(new ArrayList());
    private ConfigurationService configurationService;
    private ClientInfoService clientInfoService;
    private IPTable table = null;

    @Autowired(required=true)
    public SpiderDetectorServiceImpl(ConfigurationService configurationService, ClientInfoService clientInfoService) {
        this.configurationService = configurationService;
        this.clientInfoService = clientInfoService;
    }

    @Override
    public IPTable getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSpider(String clientIP, String proxyIPs, String hostname, String agent) {
        Pattern candidate;
        Object object;
        if (null != agent) {
            object = this.agents;
            // MONITORENTER : this.agents
            if (this.agents.isEmpty()) {
                this.loadPatterns("agents", this.agents);
            }
            // MONITOREXIT : object
            if (this.isUseCaseInsensitiveMatching()) {
                agent = StringUtils.lowerCase((String)agent);
                hostname = StringUtils.lowerCase((String)hostname);
            }
            for (Pattern candidate2 : this.agents) {
                if (null == candidate2 || !candidate2.matcher(agent).find()) continue;
                return true;
            }
        }
        if (this.clientInfoService.isUseProxiesEnabled() && proxyIPs != null) {
            for (String xfip : proxyIPs.split(",")) {
                if (!this.isSpider(xfip)) continue;
                return true;
            }
        }
        if (this.isSpider(clientIP)) {
            return true;
        }
        if (null == hostname) return false;
        object = this.domains;
        // MONITORENTER : object
        if (this.domains.isEmpty()) {
            this.loadPatterns("domains", this.domains);
        }
        // MONITOREXIT : object
        object = this.domains.iterator();
        do {
            if (!object.hasNext()) return false;
        } while (null == (candidate = (Pattern)object.next()) || !candidate.matcher(hostname).find());
        return true;
    }

    @Override
    public Set<String> readPatterns(File patternFile) throws IOException {
        HashSet<String> patterns = new HashSet<String>();
        if (!patternFile.exists() || !patternFile.isFile()) {
            return patterns;
        }
        try (BufferedReader in = new BufferedReader(new FileReader(patternFile));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).equals("")) continue;
                patterns.add(line);
            }
        }
        return patterns;
    }

    private void loadPatterns(String directory, List<Pattern> patternList) {
        String dspaceHome = this.configurationService.getProperty("dspace.dir");
        File spidersDir = new File(dspaceHome, "config/spiders");
        File patternsDir = new File(spidersDir, directory);
        if (patternsDir.exists() && patternsDir.isDirectory()) {
            for (File file : patternsDir.listFiles()) {
                Set<String> patterns;
                try {
                    patterns = this.readPatterns(file);
                }
                catch (IOException ex) {
                    log.error("Patterns not read from {}:  {}", (Object)file.getPath(), (Object)ex.getMessage());
                    continue;
                }
                for (String pattern : patterns) {
                    if (this.isUseCaseInsensitiveMatching()) {
                        pattern = StringUtils.lowerCase((String)pattern);
                    }
                    patternList.add(Pattern.compile(pattern));
                }
                log.info("Loaded pattern file:  {}", (Object)file.getPath());
            }
        } else {
            log.info("No patterns loaded from {}", (Object)patternsDir.getPath());
        }
    }

    @Override
    public boolean isSpider(HttpServletRequest request) {
        return this.isSpider(request.getRemoteAddr(), request.getHeader("X-Forwarded-For"), request.getRemoteHost(), request.getHeader("User-Agent"));
    }

    @Override
    public boolean isSpider(String ip) {
        if (this.table == null) {
            this.loadSpiderIpAddresses();
        }
        try {
            if (this.table.contains(ip)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public synchronized void loadSpiderIpAddresses() {
        block9: {
            if (this.table == null) {
                this.table = new IPTable();
                String filePath = this.configurationService.getProperty("dspace.dir");
                try {
                    File spidersDir = new File(filePath, "config/spiders");
                    if (spidersDir.exists() && spidersDir.isDirectory()) {
                        for (File file : spidersDir.listFiles()) {
                            if (!file.isFile()) continue;
                            for (String ip : this.readPatterns(file)) {
                                log.debug("Loading {}", (Object)ip);
                                if (!Character.isDigit(ip.charAt(0))) {
                                    try {
                                        ip = DnsLookup.forward(ip);
                                        log.debug("Resolved to {}", (Object)ip);
                                    }
                                    catch (IOException e) {
                                        log.warn("Not loading {}:  {}", (Object)ip, (Object)e.getMessage());
                                        continue;
                                    }
                                }
                                this.table.add(ip);
                            }
                            log.info("Loaded Spider IP file: " + file);
                        }
                        break block9;
                    }
                    log.info("No spider file loaded");
                }
                catch (IOException | IPTable.IPFormatException e) {
                    log.error("Error Loading Spiders:" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean isUseCaseInsensitiveMatching() {
        if (this.useCaseInsensitiveMatching == null) {
            try {
                this.useCaseInsensitiveMatching = this.configurationService.getBooleanProperty("usage-statistics.bots.case-insensitive");
            }
            catch (ConversionException e) {
                this.useCaseInsensitiveMatching = false;
                log.warn("Please use a boolean value for usage-statistics.bots.case-insensitive");
            }
        }
        return this.useCaseInsensitiveMatching;
    }
}

