/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.ObjectCount;
import org.dspace.statistics.SolrLoggerServiceImpl;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.DatasetSearchGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.filter.StatisticsFilter;

public class StatisticsDataSearches
extends StatisticsData {
    private static final DecimalFormat pageViewFormat = new DecimalFormat("0.00");
    private static final DecimalFormat percentageFormat = new DecimalFormat("0.00%");
    protected DSpaceObject currentDso;

    public StatisticsDataSearches(DSpaceObject dso) {
        this.currentDso = dso;
    }

    @Override
    public Dataset createDataset(Context context, int facetMinCount) throws SQLException, SolrServerException, IOException, ParseException {
        if (this.getDataset() != null) {
            return this.getDataset();
        }
        List<StatisticsFilter> filters = this.getFilters();
        ArrayList<String> defaultFilters = new ArrayList<String>();
        for (StatisticsFilter statisticsFilter : filters) {
            defaultFilters.add(statisticsFilter.toQuery());
        }
        String defaultFilterQuery = StringUtils.join(defaultFilters.iterator(), (String)" AND ");
        String query = this.getQuery();
        Dataset dataset = new Dataset(0, 0);
        List<DatasetGenerator> datasetGenerators = this.getDatasetGenerators();
        if (0 < datasetGenerators.size()) {
            DatasetGenerator datasetGenerator = datasetGenerators.get(0);
            if (datasetGenerator instanceof DatasetSearchGenerator) {
                DatasetSearchGenerator typeGenerator = (DatasetSearchGenerator)datasetGenerator;
                if (typeGenerator.getMode() == DatasetSearchGenerator.Mode.SEARCH_OVERVIEW) {
                    StringBuilder fqBuffer = new StringBuilder(defaultFilterQuery);
                    if (0 < fqBuffer.length()) {
                        fqBuffer.append(" AND ");
                    }
                    fqBuffer.append(this.getSearchFilterQuery());
                    Object[] topCounts = this.solrLoggerService.queryFacetField(query, fqBuffer.toString(), typeGenerator.getType(), typeGenerator.getMax(), typeGenerator.isPercentage() || typeGenerator.isIncludeTotal(), null, 0);
                    long totalCount = -1L;
                    if (typeGenerator.isPercentage() && 0 < topCounts.length) {
                        totalCount = topCounts[topCounts.length - 1].getCount();
                        topCounts = (ObjectCount[])ArrayUtils.subarray((Object[])topCounts, (int)0, (int)(topCounts.length - 1));
                    }
                    int nrColumns = 2;
                    if (typeGenerator.isPercentage()) {
                        ++nrColumns;
                    }
                    if (typeGenerator.isRetrievePageViews()) {
                        ++nrColumns;
                    }
                    dataset = new Dataset(topCounts.length, nrColumns);
                    dataset.setColLabel(0, "search-terms");
                    dataset.setColLabel(1, "searches");
                    if (typeGenerator.isPercentage()) {
                        dataset.setColLabel(2, "percent-total");
                    }
                    if (typeGenerator.isRetrievePageViews()) {
                        dataset.setColLabel(3, "views-search");
                    }
                    for (int i = 0; i < topCounts.length; ++i) {
                        Object queryCount = topCounts[i];
                        dataset.setRowLabel(i, String.valueOf(i + 1));
                        String displayedValue = ((ObjectCount)queryCount).getValue();
                        if (((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("usage-statistics.search.statistics.unescape.queries", (Object)Boolean.TRUE)).booleanValue()) {
                            displayedValue = displayedValue.replace("\\", "");
                        }
                        dataset.addValueToMatrix(i, 0, displayedValue);
                        dataset.addValueToMatrix(i, 1, ((ObjectCount)queryCount).getCount());
                        if (typeGenerator.isPercentage()) {
                            dataset.addValueToMatrix(i, 2, percentageFormat.format((float)((ObjectCount)queryCount).getCount() / (float)totalCount));
                        }
                        if (!typeGenerator.isRetrievePageViews()) continue;
                        String queryString = ClientUtils.escapeQueryChars((String)((ObjectCount)queryCount).getValue());
                        if (queryString.equals("")) {
                            queryString = "\"\"";
                        }
                        ObjectCount totalPageViews = this.getTotalPageViews("query:" + queryString, defaultFilterQuery, facetMinCount);
                        dataset.addValueToMatrix(i, 3, pageViewFormat.format((float)totalPageViews.getCount() / (float)((ObjectCount)queryCount).getCount()));
                    }
                } else if (typeGenerator.getMode() == DatasetSearchGenerator.Mode.SEARCH_OVERVIEW_TOTAL) {
                    ObjectCount totalCount = this.solrLoggerService.queryTotal(query, this.getSearchFilterQuery(), facetMinCount);
                    StringBuilder fqBuffer = new StringBuilder(defaultFilterQuery);
                    if (0 < fqBuffer.length()) {
                        fqBuffer.append(" AND ");
                    }
                    fqBuffer.append(this.getSearchFilterQuery());
                    ObjectCount totalFiltered = this.solrLoggerService.queryTotal(query, fqBuffer.toString(), facetMinCount);
                    fqBuffer = new StringBuilder(defaultFilterQuery);
                    if (0 < fqBuffer.length()) {
                        fqBuffer.append(" AND ");
                    }
                    fqBuffer.append("statistics_type:").append(SolrLoggerServiceImpl.StatisticsType.SEARCH_RESULT.text());
                    ObjectCount totalPageViews = this.getTotalPageViews(query, defaultFilterQuery, facetMinCount);
                    dataset = new Dataset(1, 3);
                    dataset.setRowLabel(0, "");
                    dataset.setColLabel(0, "searches");
                    dataset.addValueToMatrix(0, 0, totalFiltered.getCount());
                    dataset.setColLabel(1, "percent-total");
                    float percentTotal = totalCount.getCount() == 0L ? 0.0f : (float)totalFiltered.getCount() / (float)totalCount.getCount();
                    dataset.addValueToMatrix(0, 1, percentageFormat.format(percentTotal));
                    dataset.setColLabel(2, "views-search");
                    float pageViews = totalFiltered.getCount() == 0L ? 0.0f : (float)totalPageViews.getCount() / (float)totalFiltered.getCount();
                    dataset.addValueToMatrix(0, 2, pageViewFormat.format(pageViews));
                }
            } else {
                throw new IllegalArgumentException("Data generator with class" + datasetGenerator.getClass().getName() + " is not supported by the statistics search engine !");
            }
        }
        return dataset;
    }

    protected String getQuery() {
        Object query;
        if (this.currentDso != null) {
            query = "scopeType: " + this.currentDso.getType() + " AND ";
            query = this.currentDso instanceof DSpaceObjectLegacySupport ? (String)query + " (scopeId:" + this.currentDso.getID() + " OR scopeId:" + ((DSpaceObjectLegacySupport)((Object)this.currentDso)).getLegacyId() + ")" : (String)query + "scopeId:" + this.currentDso.getID();
        } else {
            query = "*:*";
        }
        return query;
    }

    protected ObjectCount getTotalPageViews(String query, String defaultFilterQuery, int facetMinCount) throws SolrServerException, IOException {
        StringBuilder fqBuffer = new StringBuilder(defaultFilterQuery);
        if (0 < fqBuffer.length()) {
            fqBuffer.append(" AND ");
        }
        fqBuffer.append("statistics_type:").append(SolrLoggerServiceImpl.StatisticsType.SEARCH_RESULT.text());
        return this.solrLoggerService.queryTotal(query, fqBuffer.toString(), facetMinCount);
    }

    protected String getSearchFilterQuery() {
        StringBuilder fqBuffer = new StringBuilder();
        fqBuffer.append("statistics_type:").append(SolrLoggerServiceImpl.StatisticsType.SEARCH.text());
        fqBuffer.append(" AND -page:[* TO *]");
        return fqBuffer.toString();
    }
}

