/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.statistics.factory.StatisticsServiceFactory;
import org.dspace.statistics.service.SolrLoggerService;

public class StatisticsLoggingConsumer
implements Consumer {
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected SolrLoggerService solrLoggerService = StatisticsServiceFactory.getInstance().getSolrLoggerService();
    private Set<String> toRemoveQueries = null;

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        ArrayList<Object> valsList;
        ArrayList<List<Object>> valuesList;
        ArrayList<String> fieldNames;
        Item newItem;
        String updateQuery;
        if (this.toRemoveQueries == null) {
            this.toRemoveQueries = new HashSet<String>();
        }
        UUID dsoId = event.getSubjectID();
        int dsoType = event.getSubjectType();
        int eventType = event.getEventType();
        if (eventType == 32) {
            String query = "id:" + dsoId + " AND type:" + dsoType;
            this.toRemoveQueries.add(query);
        } else if ((eventType != 2 || dsoType != 2) && eventType == 4 && event.getSubjectType() == 2) {
            Item item = (Item)this.itemService.find(ctx, event.getSubjectID());
            updateQuery = "id:" + item.getID() + " AND type:" + item.getType();
            Map<String, List<String>> indexedValues = this.solrLoggerService.queryField(updateQuery, null, null);
            ArrayList<String> storageFieldList = new ArrayList<String>();
            ArrayList<List<Object>> storageValuesList = new ArrayList<List<Object>>();
            this.solrLoggerService.update(updateQuery, "replace", storageFieldList, storageValuesList);
        }
        if (eventType == 8 && dsoType == 3 && event.getObject(ctx) instanceof Item) {
            newItem = (Item)event.getObject(ctx);
            updateQuery = "id: " + newItem.getID() + " AND type:" + newItem.getType();
            fieldNames = new ArrayList<String>();
            valuesList = new ArrayList<List<Object>>();
            fieldNames.add("owningColl");
            fieldNames.add("owningComm");
            valsList = new ArrayList<Object>();
            valsList.add(dsoId);
            valuesList.add(valsList);
            valsList = new ArrayList();
            valsList.addAll(this.findOwningCommunities(ctx, dsoId));
            valuesList.add(valsList);
            this.solrLoggerService.update(updateQuery, "addOne", fieldNames, valuesList);
        } else if (eventType == 16 && dsoType == 3 && event.getObject(ctx) instanceof Item) {
            newItem = (Item)event.getObject(ctx);
            updateQuery = "id: " + newItem.getID() + " AND type:" + newItem.getType();
            fieldNames = new ArrayList();
            valuesList = new ArrayList();
            fieldNames.add("owningColl");
            fieldNames.add("owningComm");
            valsList = new ArrayList();
            valsList.add(dsoId);
            valuesList.add(valsList);
            valsList = new ArrayList();
            valsList.addAll(this.findOwningCommunities(ctx, dsoId));
            valuesList.add(valsList);
            this.solrLoggerService.update(updateQuery, "remOne", fieldNames, valuesList);
        }
    }

    private List<Object> findOwningCommunities(Context context, UUID collId) throws SQLException {
        Collection coll = (Collection)this.collectionService.find(context, collId);
        ArrayList<Object> owningComms = new ArrayList<Object>();
        for (int i = 0; i < coll.getCommunities().size(); ++i) {
            Community community = coll.getCommunities().get(i);
            this.findComms(community, owningComms);
        }
        return owningComms;
    }

    private void findComms(Community comm, List<Object> parentComms) throws SQLException {
        List<Community> parentCommunities;
        if (comm == null) {
            return;
        }
        if (!parentComms.contains(comm.getID())) {
            parentComms.add(comm.getID());
        }
        Community parent = (parentCommunities = comm.getParentCommunities()).size() == 0 ? null : parentCommunities.get(0);
        this.findComms(parent, parentComms);
    }

    @Override
    public void end(Context ctx) throws Exception {
        if (this.toRemoveQueries != null) {
            for (String query : this.toRemoveQueries) {
                this.solrLoggerService.removeIndex(query);
            }
        }
        this.toRemoveQueries = null;
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

