/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.service.impl;

import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.services.ConfigurationService;

@Named
@Singleton
public class HttpConnectionPoolService {
    @Inject
    ConfigurationService configurationService;
    private final String configPrefix;
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private static final int DEFAULT_MAX_PER_ROUTE = 15;
    private static final int DEFAULT_KEEPALIVE = 5000;
    private static final int DEFAULT_TTL = 600;
    private static final int CHECK_INTERVAL = 1000;
    private static final int IDLE_INTERVAL = 30;
    private PoolingHttpClientConnectionManager connManager;
    private final ConnectionKeepAliveStrategy keepAliveStrategy = new KeepAliveStrategy();

    public HttpConnectionPoolService(String configPrefix) {
        this.configPrefix = configPrefix;
    }

    @PostConstruct
    protected void init() {
        this.connManager = new PoolingHttpClientConnectionManager((long)this.configurationService.getIntProperty(this.configPrefix + ".client.timeToLive", 600), TimeUnit.SECONDS);
        this.connManager.setMaxTotal(this.configurationService.getIntProperty(this.configPrefix + ".client.maxTotalConnections", 20));
        this.connManager.setDefaultMaxPerRoute(this.configurationService.getIntProperty(this.configPrefix + ".client.maxPerRoute", 15));
        IdleConnectionMonitorThread connectionMonitor = new IdleConnectionMonitorThread(this.connManager);
        connectionMonitor.setDaemon(true);
        connectionMonitor.start();
    }

    public CloseableHttpClient getClient() {
        DSpaceHttpClientFactory.getInstance().builder(true);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setKeepAliveStrategy(this.keepAliveStrategy).setConnectionManager((HttpClientConnectionManager)this.connManager).build();
        return httpClient;
    }

    public class KeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String name = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(name)) continue;
                return Long.parseLong(value) * 1000L;
            }
            return HttpConnectionPoolService.this.configurationService.getIntProperty(HttpConnectionPoolService.this.configPrefix + ".client.keepAlive", 5000);
        }
    }

    public class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(PoolingHttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(1000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

