/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory.impl;

import java.util.List;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.factory.OrcidCommonObjectFactory;
import org.dspace.orcid.model.factory.OrcidProfileSectionFactory;
import org.dspace.orcid.service.MetadataSignatureGenerator;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractOrcidProfileSectionFactory
implements OrcidProfileSectionFactory {
    protected final OrcidProfileSectionType sectionType;
    protected final OrcidProfileSyncPreference preference;
    @Autowired
    protected ItemService itemService;
    @Autowired
    protected OrcidCommonObjectFactory orcidCommonObjectFactory;
    @Autowired
    protected MetadataSignatureGenerator metadataSignatureGenerator;

    public AbstractOrcidProfileSectionFactory(OrcidProfileSectionType sectionType, OrcidProfileSyncPreference preference) {
        this.sectionType = sectionType;
        this.preference = preference;
        if (!this.getSupportedTypes().contains((Object)sectionType)) {
            throw new IllegalArgumentException(String.format("The ORCID configuration does not support the section type %s. Supported types are %s", new Object[]{sectionType, this.getSupportedTypes()}));
        }
    }

    protected abstract List<OrcidProfileSectionType> getSupportedTypes();

    @Override
    public OrcidProfileSectionType getProfileSectionType() {
        return this.sectionType;
    }

    @Override
    public OrcidProfileSyncPreference getSynchronizationPreference() {
        return this.preference;
    }

    protected List<MetadataValue> getMetadataValues(Item item, String metadataField) {
        return this.itemService.getMetadataByMetadataString(item, metadataField);
    }
}

