/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;

public class CombinedMetadatumContributor<T>
implements MetadataContributor<T> {
    private MetadataFieldConfig field;
    private LinkedList<MetadataContributor> metadatumContributors;
    private String separator;
    private MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping;

    public CombinedMetadatumContributor() {
    }

    public CombinedMetadatumContributor(MetadataFieldConfig field, List<MetadataContributor> metadatumContributors, String separator) {
        this.field = field;
        this.metadatumContributors = (LinkedList)metadatumContributors;
        this.separator = separator;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<T, MetadataContributor<T>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
        for (MetadataContributor metadatumContributor : this.metadatumContributors) {
            metadatumContributor.setMetadataFieldMapping(metadataFieldMapping);
        }
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(T t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        LinkedList<LinkedList> metadatumLists = new LinkedList<LinkedList>();
        for (MetadataContributor metadatumContributor : this.metadatumContributors) {
            LinkedList metadatums = (LinkedList)metadatumContributor.contributeMetadata(t);
            metadatumLists.add(metadatums);
        }
        for (int i = 0; i < ((LinkedList)metadatumLists.getFirst()).size(); ++i) {
            StringBuilder value = new StringBuilder();
            for (LinkedList metadatums : metadatumLists) {
                value.append(((MetadatumDTO)metadatums.get(i)).getValue());
                if (metadatums.equals(metadatumLists.getLast())) continue;
                value.append(this.separator);
            }
            values.add(this.metadataFieldMapping.toDCValue(this.field, value.toString()));
        }
        return values;
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public LinkedList<MetadataContributor> getMetadatumContributors() {
        return this.metadatumContributors;
    }

    public void setMetadatumContributors(LinkedList<MetadataContributor> metadatumContributors) {
        this.metadatumContributors = metadatumContributors;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

