/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.datacite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.DoiCheck;
import org.dspace.importer.external.service.components.QuerySource;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class DataCiteImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<String>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private LiveImportClient liveImportClient;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public String getImportSource() {
        return "datacite";
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public ImportRecord getRecord(String recordId) throws MetadataSourceException {
        Collection<ImportRecord> records = this.getRecords(recordId, 0, 1);
        if (records.size() == 0) {
            return null;
        }
        return records.stream().findFirst().get();
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        String id = this.getID(query);
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        params.put("uriParameters", uriParameters);
        if (StringUtils.isBlank((CharSequence)id)) {
            id = query;
        }
        uriParameters.put("query", id);
        uriParameters.put("page[size]", "1");
        int timeoutMs = this.configurationService.getIntProperty("datacite.timeout", 180000);
        String url = this.configurationService.getProperty("datacite.url", "https://api.datacite.org/dois/");
        String responseString = this.liveImportClient.executeHttpGetRequest(timeoutMs, url, params);
        JsonNode jsonNode = this.convertStringJsonToJsonNode(responseString);
        if (jsonNode == null) {
            log.warn("DataCite returned invalid JSON");
            throw new MetadataSourceException("Could not read datacite source");
        }
        JsonNode dataNode = jsonNode.at("/meta/total");
        if (dataNode != null) {
            try {
                return Integer.valueOf(dataNode.toString());
            }
            catch (Exception e) {
                log.debug("Could not read integer value" + dataNode.toString());
            }
        }
        return 0;
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return this.getRecordsCount(StringUtils.isBlank((CharSequence)id) ? query.toString() : id);
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        String url;
        int timeoutMs;
        String responseString;
        JsonNode jsonNode;
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        String id = this.getID(query);
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        HashMap<String, String> uriParameters = new HashMap<String, String>();
        params.put("uriParameters", uriParameters);
        if (StringUtils.isBlank((CharSequence)id)) {
            id = query;
        }
        uriParameters.put("query", id);
        if (start > 0 && count > 0) {
            uriParameters.put("page[number]", Integer.toString(start / count + 1));
        }
        if (count > 0) {
            uriParameters.put("page[size]", Integer.toString(count));
        }
        if ((jsonNode = this.convertStringJsonToJsonNode(responseString = this.liveImportClient.executeHttpGetRequest(timeoutMs = this.configurationService.getIntProperty("datacite.timeout", 180000), url = this.configurationService.getProperty("datacite.url", "https://api.datacite.org/dois/"), params))) == null) {
            log.warn("DataCite returned invalid JSON");
            return records;
        }
        JsonNode dataNode = jsonNode.at("/data");
        if (dataNode.isArray()) {
            for (JsonNode singleDoiNode : dataNode) {
                JsonNode singleDoiNodeAttribute = singleDoiNode.at("/attributes");
                if (singleDoiNodeAttribute.isMissingNode()) continue;
                records.add(this.transformSourceRecords(singleDoiNodeAttribute.toString()));
            }
        } else {
            JsonNode singleDoiNodeAttribute = dataNode.at("/attributes");
            if (!singleDoiNodeAttribute.isMissingNode()) {
                records.add(this.transformSourceRecords(singleDoiNodeAttribute.toString()));
            }
        }
        return records;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return this.getRecords(StringUtils.isBlank((CharSequence)id) ? query.toString() : id, 0, -1);
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return this.getRecord(StringUtils.isBlank((CharSequence)id) ? query.toString() : id);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        String id = this.getID(query.toString());
        return this.getRecords(StringUtils.isBlank((CharSequence)id) ? query.toString() : id, 0, -1);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for DataCite");
    }

    public String getID(String query) {
        if (DoiCheck.isDoi(query)) {
            return query;
        }
        if (query.contains("%252F")) {
            query = query.replace("%252F", "/");
        }
        if (DoiCheck.isDoi(query)) {
            return query;
        }
        return "";
    }
}

