/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle.hdlresolver;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class HdlResolverDTO {
    private final String[] splittedString;
    private final String handle;

    private static String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    public HdlResolverDTO(String requestURL, String resolverSubPath) {
        Validate.notBlank((CharSequence)requestURL, (String)"RequestURI not specified", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)resolverSubPath, (String)"fullPath not specified", (Object[])new Object[0]);
        this.splittedString = requestURL.split(resolverSubPath);
        this.handle = Objects.nonNull(this.splittedString) && this.splittedString.length > 1 ? HdlResolverDTO.decode(this.splittedString[1]) : null;
    }

    public final String[] getSplittedString() {
        return this.splittedString;
    }

    public final String getHandle() {
        return this.handle;
    }

    public boolean isValid() {
        return Objects.nonNull(this.handle) && !"null".equalsIgnoreCase(this.handle) && !this.handle.trim().isEmpty();
    }
}

