/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordHash {
    private static final Logger log = LoggerFactory.getLogger(PasswordHash.class);
    private static final ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-512";
    private static final String ALGORITHM_PROPERTY = "authentication-password.digestAlgorithm";
    private static final int SALT_BYTES = 16;
    private static final int HASH_ROUNDS = 1024;
    private static final int SEED_BYTES = 64;
    private static final int RESEED_INTERVAL = 100;
    private static SecureRandom rng = null;
    private static int rngUses;
    private String algorithm;
    private byte[] salt;
    private byte[] hash;

    private PasswordHash() {
    }

    public PasswordHash(String algorithm, byte[] salt, byte[] hash) {
        this.algorithm = null != algorithm && algorithm.isEmpty() ? null : algorithm;
        this.salt = salt;
        this.hash = hash;
    }

    public PasswordHash(String algorithm, String salt, String hash) throws DecoderException {
        this.algorithm = null != algorithm && algorithm.isEmpty() ? null : algorithm;
        this.salt = (byte[])(null == salt ? null : Hex.decodeHex((char[])salt.toCharArray()));
        this.hash = (byte[])(null == hash ? null : Hex.decodeHex((char[])hash.toCharArray()));
    }

    public PasswordHash(String password) {
        this.salt = this.generateSalt();
        this.algorithm = (String)config.getPropertyAsType(ALGORITHM_PROPERTY, (Object)DEFAULT_DIGEST_ALGORITHM);
        try {
            this.hash = this.digest(this.salt, this.algorithm, password);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
            this.hash = new byte[]{0};
        }
    }

    public boolean matches(String secret) {
        byte[] candidate;
        try {
            candidate = this.digest(this.salt, this.algorithm, secret);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage());
            return false;
        }
        return Arrays.equals(candidate, this.hash);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String getHashString() {
        if (null != this.hash) {
            return new String(Hex.encodeHex((byte[])this.hash));
        }
        return null;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSaltString() {
        if (null != this.salt) {
            return new String(Hex.encodeHex((byte[])this.salt));
        }
        return null;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static String getDefaultAlgorithm() {
        return DEFAULT_DIGEST_ALGORITHM;
    }

    private synchronized byte[] generateSalt() {
        if (null == rng) {
            rng = new SecureRandom();
            log.info("Initialized a random number stream using {} provided by {}", (Object)rng.getAlgorithm(), (Object)rng.getProvider());
            rngUses = 0;
        }
        if (rngUses++ > 100) {
            log.debug("Re-seeding the RNG");
            rng.setSeed(rng.generateSeed(64));
            rngUses = 0;
        }
        this.salt = new byte[16];
        rng.nextBytes(this.salt);
        return this.salt;
    }

    private byte[] digest(byte[] salt, String algorithm, String secret) throws NoSuchAlgorithmException {
        if (null == secret) {
            secret = "";
        }
        if (null == algorithm) {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            digester.update(secret.getBytes(UTF_8));
            return digester.digest();
        }
        MessageDigest digester = MessageDigest.getInstance(algorithm);
        if (null != salt) {
            digester.update(salt);
        }
        digester.update(secret.getBytes(UTF_8));
        for (int round = 1; round < 1024; ++round) {
            byte[] lastRound = digester.digest();
            digester.reset();
            digester.update(lastRound);
        }
        return digester.digest();
    }
}

