/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.indexobject.factory;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.indexobject.factory.IndexFactory;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class IndexObjectFactoryFactory {
    @Autowired
    protected WorkspaceItemService workspaceItemService;
    @Autowired
    protected XmlWorkflowItemService xmlWorkflowItemService;
    @Autowired
    protected ClaimedTaskService claimedTaskService;
    @Autowired
    protected PoolTaskService poolTaskService;

    public abstract List<IndexFactory> getIndexFactories();

    public IndexFactory getIndexableObjectFactory(IndexableObject indexableObject) {
        return this.getIndexableObjectFactory(indexableObject.getType());
    }

    public IndexFactory getIndexableObjectFactory(String indexableObjectUniqueString) {
        return this.getIndexFactoryByType(StringUtils.substringBefore((String)indexableObjectUniqueString, (String)"-"));
    }

    public IndexFactory getIndexFactoryByType(String indexableFactoryType) {
        for (IndexFactory indexableObjectFactory : this.getIndexFactories()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)indexableObjectFactory.getType(), (CharSequence)indexableFactoryType)) continue;
            return indexableObjectFactory;
        }
        return null;
    }

    public List<IndexableObject> getIndexableObjects(Context context, Object object) throws SQLException {
        for (IndexFactory indexableObjectFactory : this.getIndexFactories()) {
            if (!indexableObjectFactory.supports(object)) continue;
            return indexableObjectFactory.getIndexableObjects(context, object);
        }
        throw new IllegalArgumentException("The object: " + object.getClass().getName() + " cannot be indexed");
    }

    public static IndexObjectFactoryFactory getInstance() {
        return (IndexObjectFactoryFactory)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("indexObjectFactoryFactory", IndexObjectFactoryFactory.class);
    }
}

