/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.dspace.curate.Reporter;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;

public class FileReporter
implements Reporter {
    private final Writer writer;

    public FileReporter() throws IOException {
        Date now = GregorianCalendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'hhmmssSSS");
        String filename = String.format("curation-%s.report", sdf.format(now));
        ConfigurationService cfg = new DSpace().getConfigurationService();
        String reportDir = cfg.getProperty("report.dir");
        Path reportPath = null == reportDir ? Paths.get(cfg.getProperty("dspace.dir"), "reports", filename) : Paths.get(reportDir, filename);
        this.writer = new FileWriter(reportPath.toFile());
    }

    @Override
    public Appendable append(CharSequence cs) throws IOException {
        this.writer.append(cs);
        return this;
    }

    @Override
    public Appendable append(CharSequence cs, int i, int i1) throws IOException {
        this.writer.append(cs, i, i1);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.writer.append(c);
        return this;
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

