/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PathsClassLoader
extends ClassLoader {
    private final String[] classpath;

    PathsClassLoader(ClassLoader parent, String[] classpath) {
        super(parent);
        this.classpath = classpath;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> found = null;
        for (String aPath : this.classpath) {
            byte[] body;
            int bodySize;
            String bodyPath = name.replace('.', '/');
            File pathFile = new File(aPath);
            if (pathFile.isDirectory()) {
                File bodyFile = new File(pathFile, bodyPath + ".class");
                if (!bodyFile.exists()) continue;
                int bodySize2 = (int)bodyFile.length();
                byte[] body2 = new byte[bodySize2];
                FileInputStream bodyStream = null;
                try {
                    int len;
                    bodyStream = new FileInputStream(bodyFile);
                    int pos = 0;
                    while ((pos += (len = bodyStream.read(body2, pos, bodySize2))) < bodySize2) {
                    }
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Class body not read", e);
                }
                finally {
                    if (null != bodyStream) {
                        try {
                            bodyStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                found = this.defineClass(name, body2, 0, bodySize2);
                break;
            }
            if (!pathFile.isFile()) continue;
            InputStream bodyStream = null;
            JarFile jar = null;
            try {
                int len;
                jar = new JarFile(pathFile);
                JarEntry entry = jar.getJarEntry(bodyPath + ".class");
                if (null == entry) continue;
                bodyStream = jar.getInputStream(entry);
                bodySize = (int)entry.getSize();
                body = new byte[bodySize];
                int pos = 0;
                while ((pos += (len = bodyStream.read(body, pos, bodySize))) < bodySize) {
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Class body not read", e);
            }
            finally {
                if (null != bodyStream) {
                    try {
                        bodyStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (null != jar) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            found = this.defineClass(name, body, 0, bodySize);
            break;
        }
        if (null == found) {
            throw new ClassNotFoundException(name);
        }
        this.resolveClass(found);
        return found;
    }
}

