/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.service.LicenseService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Request;
import org.dspace.web.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseServiceImpl
implements LicenseService {
    private final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    protected String license;

    protected LicenseServiceImpl() {
    }

    @Override
    public void writeLicenseFile(String licenseFile, String newLicense) {
        try {
            FileOutputStream fos = new FileOutputStream(licenseFile);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(newLicense);
            out.close();
        }
        catch (IOException e) {
            this.log.warn("license_write: " + e.getLocalizedMessage());
        }
        this.license = newLicense;
    }

    @Override
    public String getLicenseText(String licenseFile) {
        FileInputStream is = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            String lineIn;
            is = new FileInputStream(licenseFile);
            ir = new InputStreamReader((InputStream)is, "UTF-8");
            br = new BufferedReader(ir);
            this.license = "";
            while ((lineIn = br.readLine()) != null) {
                this.license = this.license + lineIn + "\n";
            }
        }
        catch (IOException e) {
            this.log.error("Can't load configuration", (Throwable)e);
            throw new IllegalStateException("Failed to read default license.", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.license;
    }

    @Override
    public String getDefaultSubmissionLicense() {
        this.init();
        return this.license;
    }

    protected void init() {
        Context context = this.obtainContext();
        File licenseFile = new File(I18nUtil.getDefaultLicense(context));
        FileInputStream fir = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            String lineIn;
            fir = new FileInputStream(licenseFile);
            ir = new InputStreamReader((InputStream)fir, "UTF-8");
            br = new BufferedReader(ir);
            this.license = "";
            while ((lineIn = br.readLine()) != null) {
                this.license = this.license + lineIn + "\n";
            }
            br.close();
        }
        catch (IOException e) {
            this.log.error("Can't load license: " + licenseFile.toString(), (Throwable)e);
            throw new IllegalStateException("Cannot load license: " + licenseFile.toString(), e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException iOException) {}
            }
            if (fir != null) {
                try {
                    fir.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Context obtainContext() {
        try {
            Request currentRequest = DSpaceServicesFactory.getInstance().getRequestService().getCurrentRequest();
            if (currentRequest != null) {
                HttpServletRequest request = currentRequest.getHttpServletRequest();
                return ContextUtil.obtainContext(request);
            }
        }
        catch (Exception e) {
            this.log.error("Can't load current request context.");
        }
        return new Context();
    }
}

