/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.AbstractMETSIngester;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.jdom2.Element;

public class DSpaceAIPIngester
extends AbstractMETSIngester {
    private static Logger log = LogManager.getLogger(DSpaceAIPIngester.class);

    @Override
    void checkManifest(METSManifest manifest) throws MetadataValidationException {
        String profile = manifest.getProfile();
        if (profile == null) {
            throw new MetadataValidationException("Cannot accept METS with no PROFILE attribute!");
        }
        if (!profile.equals("http://www.dspace.org/schema/aip/mets_aip_1_0.xsd")) {
            throw new MetadataValidationException("METS has unacceptable PROFILE attribute, profile=" + profile);
        }
    }

    @Override
    public void crosswalkObjectDmd(Context context, DSpaceObject dso, METSManifest manifest, AbstractMETSIngester.MdrefManager callback, Element[] dmds, PackageParameters params) throws CrosswalkException, PackageValidationException, AuthorizeException, SQLException, IOException {
        int i;
        int found = -1;
        String userDmd = null;
        if (params != null) {
            userDmd = params.getProperty("dmd");
        }
        if (userDmd != null && userDmd.length() > 0) {
            for (i = 0; i < dmds.length; ++i) {
                if (!userDmd.equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"DIM".equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        if (found == -1) {
            for (i = 0; i < dmds.length; ++i) {
                if (!"MODS".equalsIgnoreCase(manifest.getMdType(dmds[i]))) continue;
                found = i;
            }
        }
        String groupID = null;
        if (found >= 0) {
            manifest.crosswalkItemDmd(context, params, dso, dmds[found], callback);
            groupID = dmds[found].getAttributeValue("GROUPID");
            if (groupID != null) {
                for (int i2 = 0; i2 < dmds.length; ++i2) {
                    String g = dmds[i2].getAttributeValue("GROUPID");
                    if (g == null || g.equals(groupID)) continue;
                    manifest.crosswalkItemDmd(context, params, dso, dmds[i2], callback);
                }
            }
        } else if (dmds.length > 0) {
            manifest.crosswalkItemDmd(context, params, dso, dmds[0], callback);
        } else {
            throw new MetadataValidationException("DSpaceAIPIngester: Could not find an acceptable object-wide DMD section in manifest.");
        }
    }

    @Override
    public void addLicense(Context context, Item item, String license, Collection collection, PackageParameters params) throws PackageValidationException, AuthorizeException, SQLException, IOException {
        boolean newLicense = false;
        if (!params.restoreModeEnabled()) {
            newLicense = true;
        }
        if (!params.getBooleanProperty("manifestOnly", false) && PackageUtils.findDepositLicense(context, item) == null) {
            newLicense = true;
        }
        if (newLicense) {
            PackageUtils.addDepositLicense(context, license, item, collection);
        }
    }

    @Override
    public void finishObject(Context context, DSpaceObject dso, PackageParameters params) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
    }

    @Override
    public void finishBitstream(Context context, Bitstream bs, Element mfile, METSManifest manifest, PackageParameters params) throws MetadataValidationException, SQLException, AuthorizeException, IOException {
    }

    @Override
    public int getObjectType(METSManifest manifest) throws PackageValidationException {
        int type;
        Element mets = manifest.getMets();
        String typeStr = mets.getAttributeValue("TYPE");
        if (typeStr == null || typeStr.length() == 0) {
            throw new PackageValidationException("Manifest is missing the required mets@TYPE attribute.");
        }
        if (typeStr.startsWith("DSpace ")) {
            typeStr = typeStr.substring(7);
        }
        if ((type = Constants.getTypeID(typeStr)) < 0) {
            throw new PackageValidationException("Manifest has unrecognized value in mets@TYPE attribute: " + typeStr);
        }
        return type;
    }

    @Override
    public String getConfigurationName() {
        return "dspaceAIP";
    }

    @Override
    public String getParameterHelp() {
        String parentHelp = super.getParameterHelp();
        return parentHelp + "\n\n* createMetadataFields=[boolean]      If true, ingest attempts to create any missing metadata fields.If false, ingest will fail if a metadata field is encountered which doesn't already exist. (default = true)\n\n* dmd=[dmdSecType]      Type of the METS <dmdSec> which should be used to restore item metadata (defaults to DIM, then MODS)";
    }
}

