/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Site;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.Verifier;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class MODSDisseminationCrosswalk
extends SelfNamedPlugin
implements DisseminationCrosswalk {
    private static final Logger log = LogManager.getLogger(MODSDisseminationCrosswalk.class);
    private static final String CONFIG_PREFIX = "crosswalk.mods.properties.";
    protected final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    protected static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static String[] aliases = null;
    public static final Namespace MODS_NS;
    private static final Namespace XLINK_NS;
    private static final Namespace[] namespaces;
    public static final String MODS_XSD = "http://www.loc.gov/standards/mods/v3/mods-3-1.xsd";
    private static final String schemaLocation;
    private static final XMLOutputter outputUgly;
    private static final SAXBuilder builder;
    private Map<String, modsTriple> modsMap = null;

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private void initMap() throws CrosswalkInternalException {
        if (this.modsMap != null) {
            return;
        }
        String myAlias = this.getPluginInstanceName();
        if (myAlias == null) {
            log.error("Must use PluginService to instantiate MODSDisseminationCrosswalk so the class knows its name.");
            return;
        }
        String cmPropName = CONFIG_PREFIX + myAlias;
        String propsFilename = configurationService.getProperty(cmPropName);
        if (propsFilename == null) {
            String msg = "MODS crosswalk missing configuration file for crosswalk named \"" + myAlias + "\"";
            log.error(msg);
            throw new CrosswalkInternalException(msg);
        }
        String parent = configurationService.getProperty("dspace.dir") + File.separator + "config" + File.separator;
        File propsFile = new File(parent, propsFilename);
        Properties modsConfig = new Properties();
        FileInputStream pfs = null;
        try {
            pfs = new FileInputStream(propsFile);
            modsConfig.load(pfs);
        }
        catch (IOException e) {
            log.error("Error opening or reading MODS properties file: " + propsFile.toString() + ": " + e.toString());
            throw new CrosswalkInternalException("MODS crosswalk cannot open config file: " + e.toString(), e);
        }
        finally {
            if (pfs != null) {
                try {
                    pfs.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.modsMap = new HashMap<String, modsTriple>();
        Enumeration<?> pe = modsConfig.propertyNames();
        while (pe.hasMoreElements()) {
            String qdc = (String)pe.nextElement();
            String val = modsConfig.getProperty(qdc);
            String[] pair = val.split("\\s+\\|\\s+", 2);
            if (pair.length < 2) {
                log.warn("Illegal MODS mapping in " + propsFile.toString() + ", line = " + qdc + " = " + val);
                continue;
            }
            modsTriple trip = modsTriple.create(qdc, pair[0], pair[1]);
            if (trip == null) continue;
            this.modsMap.put(qdc, trip);
        }
    }

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return schemaLocation;
    }

    @Override
    public List<Element> disseminateList(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        return this.disseminateListInternal(dso, true);
    }

    @Override
    public Element disseminateElement(Context context, DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element root = new Element("mods", MODS_NS);
        root.setAttribute("schemaLocation", schemaLocation, XSI_NS);
        root.addContent(this.disseminateListInternal(dso, false));
        return root;
    }

    private List<Element> disseminateListInternal(DSpaceObject dso, boolean addSchema) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        List<MetadataValueDTO> dcvs = null;
        if (dso.getType() == 2) {
            dcvs = this.item2Metadata((Item)dso);
        } else if (dso.getType() == 3) {
            dcvs = this.collection2Metadata((Collection)dso);
        } else if (dso.getType() == 4) {
            dcvs = this.community2Metadata((Community)dso);
        } else if (dso.getType() == 5) {
            dcvs = this.site2Metadata((Site)dso);
        } else {
            throw new CrosswalkObjectNotSupported("MODSDisseminationCrosswalk can only crosswalk Items, Collections, or Communities");
        }
        this.initMap();
        ArrayList<Element> result = new ArrayList<Element>(dcvs.size());
        for (MetadataValueDTO dcv : dcvs) {
            List matches;
            String qdc = dcv.getSchema() + "." + dcv.getElement();
            if (dcv.getQualifier() != null) {
                qdc = qdc + "." + dcv.getQualifier();
            }
            String value = dcv.getValue();
            modsTriple trip = this.modsMap.get(qdc);
            if (trip == null) {
                log.warn("WARNING: " + this.getPluginInstanceName() + ": No MODS mapping for \"" + qdc + "\"");
                continue;
            }
            Element me = trip.xml.clone();
            if (addSchema) {
                me.setAttribute("schemaLocation", schemaLocation, XSI_NS);
            }
            if ((matches = trip.xpath.evaluate((Object)me)).isEmpty()) {
                log.warn("XPath \"" + trip.xpath.getExpression() + "\" found no elements in \"" + outputUgly.outputString(me) + "\", qdc=" + qdc);
            }
            for (Object match : matches) {
                if (match instanceof Element) {
                    ((Element)match).setText(this.checkedString(value));
                    continue;
                }
                if (match instanceof Attribute) {
                    ((Attribute)match).setValue(this.checkedString(value));
                    continue;
                }
                if (match instanceof Text) {
                    ((Text)match).setText(this.checkedString(value));
                    continue;
                }
                log.warn("Got unknown object from XPath, class=" + match.getClass().getName());
            }
            result.add(me);
        }
        return result;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2 || dso.getType() == 3 || dso.getType() == 4 || dso.getType() == 5;
    }

    @Override
    public boolean preferList() {
        return false;
    }

    protected List<MetadataValueDTO> site2Metadata(Site site) {
        ArrayList<MetadataValueDTO> metadata = new ArrayList<MetadataValueDTO>();
        String identifier_uri = this.handleService.getCanonicalPrefix() + site.getHandle();
        String title = site.getName();
        String url = site.getURL();
        metadata.add(this.createDCValue("identifier.uri", null, identifier_uri));
        if (url != null) {
            metadata.add(this.createDCValue("identifier.uri", null, url));
        }
        if (title != null) {
            metadata.add(this.createDCValue("title", null, title));
        }
        return metadata;
    }

    protected List<MetadataValueDTO> community2Metadata(Community community) {
        ArrayList<MetadataValueDTO> metadata = new ArrayList<MetadataValueDTO>();
        String description = this.communityService.getMetadataFirstValue(community, CommunityService.MD_INTRODUCTORY_TEXT, "*");
        String description_abstract = this.communityService.getMetadataFirstValue(community, CommunityService.MD_SHORT_DESCRIPTION, "*");
        String description_table = this.communityService.getMetadataFirstValue(community, CommunityService.MD_SIDEBAR_TEXT, "*");
        String identifier_uri = this.handleService.getCanonicalPrefix() + community.getHandle();
        String rights = this.communityService.getMetadataFirstValue(community, CommunityService.MD_COPYRIGHT_TEXT, "*");
        String title = this.communityService.getMetadataFirstValue(community, CommunityService.MD_NAME, "*");
        metadata.add(this.createDCValue("description", null, description));
        if (description_abstract != null) {
            metadata.add(this.createDCValue("description", "abstract", description_abstract));
        }
        if (description_table != null) {
            metadata.add(this.createDCValue("description", "tableofcontents", description_table));
        }
        metadata.add(this.createDCValue("identifier.uri", null, identifier_uri));
        if (rights != null) {
            metadata.add(this.createDCValue("rights", null, rights));
        }
        if (title != null) {
            metadata.add(this.createDCValue("title", null, title));
        }
        return metadata;
    }

    protected List<MetadataValueDTO> collection2Metadata(Collection collection) {
        ArrayList<MetadataValueDTO> metadata = new ArrayList<MetadataValueDTO>();
        String description = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_INTRODUCTORY_TEXT, "*");
        String description_abstract = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_SHORT_DESCRIPTION, "*");
        String description_table = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_SIDEBAR_TEXT, "*");
        String identifier_uri = this.handleService.getCanonicalPrefix() + collection.getHandle();
        String provenance = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_PROVENANCE_DESCRIPTION, "*");
        String rights = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_COPYRIGHT_TEXT, "*");
        String rights_license = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_LICENSE, "*");
        String title = this.collectionService.getMetadataFirstValue(collection, CollectionService.MD_NAME, "*");
        if (description != null) {
            metadata.add(this.createDCValue("description", null, description));
        }
        if (description_abstract != null) {
            metadata.add(this.createDCValue("description", "abstract", description_abstract));
        }
        if (description_table != null) {
            metadata.add(this.createDCValue("description", "tableofcontents", description_table));
        }
        metadata.add(this.createDCValue("identifier", "uri", identifier_uri));
        if (provenance != null) {
            metadata.add(this.createDCValue("provenance", null, provenance));
        }
        if (rights != null) {
            metadata.add(this.createDCValue("rights", null, rights));
        }
        if (rights_license != null) {
            metadata.add(this.createDCValue("rights.license", null, rights_license));
        }
        if (title != null) {
            metadata.add(this.createDCValue("title", null, title));
        }
        return metadata;
    }

    protected List<MetadataValueDTO> item2Metadata(Item item) {
        List<MetadataValue> dcvs = this.itemService.getMetadata(item, "*", "*", "*", "*");
        ArrayList<MetadataValueDTO> result = new ArrayList<MetadataValueDTO>();
        for (MetadataValue metadataValue : dcvs) {
            result.add(new MetadataValueDTO(metadataValue));
        }
        return result;
    }

    protected MetadataValueDTO createDCValue(String element, String qualifier, String value) {
        MetadataValueDTO dcv = new MetadataValueDTO();
        dcv.setSchema("dc");
        dcv.setElement(element);
        dcv.setQualifier(qualifier);
        dcv.setValue(value);
        return dcv;
    }

    private String checkedString(String value) {
        if (value == null) {
            return null;
        }
        String reason = Verifier.checkCharacterData((String)value);
        if (reason == null) {
            return value;
        }
        if (log.isDebugEnabled()) {
            log.debug("Filtering out non-XML characters in string, reason=" + reason);
        }
        StringBuilder result = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    static {
        ArrayList<String> aliasList = new ArrayList<String>();
        List keys = configurationService.getPropertyKeys(CONFIG_PREFIX);
        for (String key : keys) {
            aliasList.add(key.substring(CONFIG_PREFIX.length()));
        }
        aliases = aliasList.toArray(new String[aliasList.size()]);
        MODS_NS = Namespace.getNamespace((String)"mods", (String)"http://www.loc.gov/mods/v3");
        XLINK_NS = Namespace.getNamespace((String)"xlink", (String)"http://www.w3.org/1999/xlink");
        namespaces = new Namespace[]{MODS_NS, XLINK_NS};
        schemaLocation = MODS_NS.getURI() + " http://www.loc.gov/standards/mods/v3/mods-3-1.xsd";
        outputUgly = new XMLOutputter();
        builder = XMLUtils.getSAXBuilder();
    }

    static class modsTriple {
        public String qdc = null;
        public Element xml = null;
        public XPathExpression xpath = null;

        modsTriple() {
        }

        public static modsTriple create(String qdc, String xml, String xpath) {
            modsTriple result = new modsTriple();
            String prolog = "<mods xmlns:" + MODS_NS.getPrefix() + "=\"" + MODS_NS.getURI() + "\" xmlns:" + XLINK_NS.getPrefix() + "=\"" + XLINK_NS.getURI() + "\">";
            String postlog = "</mods>";
            try {
                result.qdc = qdc;
                result.xpath = XPathFactory.instance().compile(xpath, Filters.fpassthrough(), null, new Namespace[]{MODS_NS, XLINK_NS});
                Document d = builder.build((Reader)new StringReader(prolog + xml + "</mods>"));
                result.xml = (Element)d.getRootElement().getContent(0);
            }
            catch (IOException | JDOMException je) {
                log.error("Error initializing modsTriple(\"" + qdc + "\",\"" + xml + "\",\"" + xpath + "\"): got " + je.toString());
                return null;
            }
            return result;
        }
    }
}

