/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.SolrAuthorityInterface;
import org.dspace.authority.orcid.Orcidv3AuthorityValue;
import org.dspace.external.OrcidRestConnector;
import org.dspace.external.provider.orcid.xml.XMLtoBio;
import org.dspace.orcid.model.factory.OrcidFactoryUtils;
import org.orcid.jaxb.model.v3.release.common.OrcidIdentifier;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.orcid.jaxb.model.v3.release.search.Result;

public class Orcidv3SolrAuthorityImpl
implements SolrAuthorityInterface {
    private static final Logger log = LogManager.getLogger();
    private OrcidRestConnector orcidRestConnector;
    private String OAUTHUrl;
    private String clientId;
    private String clientSecret;
    private String accessToken;
    private int maxClientRetries = 3;

    public void setOAUTHUrl(String oAUTHUrl) {
        this.OAUTHUrl = oAUTHUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void init() {
        this.initializeAccessToken();
    }

    public void initializeAccessToken() {
        if (this.maxClientRetries <= 0 || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.accessToken)) {
            return;
        }
        try {
            this.accessToken = OrcidFactoryUtils.retrieveAccessToken(this.clientId, this.clientSecret, this.OAUTHUrl).orElse(null);
        }
        catch (IOException e) {
            log.error("Error retrieving ORCID access token, {} retries left", (Object)(--this.maxClientRetries));
        }
    }

    public void setOrcidRestConnector(OrcidRestConnector orcidRestConnector) {
        this.orcidRestConnector = orcidRestConnector;
    }

    @Override
    public List<AuthorityValue> queryAuthorities(String text, int max) {
        this.initializeAccessToken();
        List<Person> bios = this.queryBio(text, max);
        ArrayList<AuthorityValue> result = new ArrayList<AuthorityValue>();
        for (Person person : bios) {
            Orcidv3AuthorityValue orcidAuthorityValue = Orcidv3AuthorityValue.create(person);
            if (orcidAuthorityValue == null) continue;
            result.add(orcidAuthorityValue);
        }
        return result;
    }

    @Override
    public AuthorityValue queryAuthorityID(String id) {
        this.initializeAccessToken();
        Person person = this.getBio(id);
        Orcidv3AuthorityValue valueFromPerson = Orcidv3AuthorityValue.create(person);
        return valueFromPerson;
    }

    public Person getBio(String id) {
        log.debug("getBio called with ID=" + id);
        if (!this.isValid(id)) {
            return null;
        }
        if (this.orcidRestConnector == null) {
            log.error("ORCID REST connector is null, returning null Person");
            return null;
        }
        this.initializeAccessToken();
        InputStream bioDocument = this.orcidRestConnector.get(id + (id.endsWith("/person") ? "" : "/person"), this.accessToken);
        XMLtoBio converter = new XMLtoBio();
        return converter.convertSinglePerson(bioDocument);
    }

    public List<Person> queryBio(String text, int start, int rows) {
        if (rows > 100) {
            throw new IllegalArgumentException("The maximum number of results to retrieve cannot exceed 100.");
        }
        if (this.orcidRestConnector == null) {
            log.error("ORCID REST connector is not initialized, returning empty list");
            return Collections.emptyList();
        }
        this.initializeAccessToken();
        String searchPath = "search?q=" + URLEncoder.encode(text) + "&start=" + start + "&rows=" + rows;
        log.debug("queryBio searchPath=" + searchPath + " accessToken=" + this.accessToken);
        InputStream bioDocument = this.orcidRestConnector.get(searchPath, this.accessToken);
        XMLtoBio converter = new XMLtoBio();
        Object results = converter.convert(bioDocument);
        LinkedList<Person> bios = new LinkedList<Person>();
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            OrcidIdentifier orcidIdentifier = result.getOrcidIdentifier();
            if (orcidIdentifier == null) continue;
            log.debug("Found OrcidId=" + orcidIdentifier.toString());
            String orcid = orcidIdentifier.getPath();
            Person bio = this.getBio(orcid);
            if (bio == null) continue;
            bios.add(bio);
        }
        try {
            bioDocument.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return bios;
    }

    public List<Person> queryBio(String text, int max) {
        return this.queryBio(text, 0, max);
    }

    private boolean isValid(String text) {
        return StringUtils.isNotBlank((String)text) && text.matches("\\d{4}-\\d{4}-\\d{4}-(\\d{3}X|\\d{4})");
    }
}

