/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa.submit;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.submit.ISSNItemExtractor;
import org.dspace.app.sherpa.submit.SHERPASubmitConfigurationService;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;

public class SHERPASubmitService {
    protected SHERPAService sherpaService;
    protected SHERPASubmitConfigurationService configuration;
    private static Logger log = LogManager.getLogger(SHERPASubmitService.class);

    public void setConfiguration(SHERPASubmitConfigurationService configuration) {
        this.configuration = configuration;
    }

    public void setSherpaService(SHERPAService sherpaService) {
        this.sherpaService = sherpaService;
    }

    public SHERPAResponse searchRelatedJournals(Context context, Item item) {
        Set<String> issns = this.getISSNs(context, item);
        if (issns == null || issns.size() == 0) {
            return null;
        }
        for (String issn : issns) {
            SHERPAResponse response = this.sherpaService.searchByJournalISSN(issn);
            if (response.isError()) {
                log.warn("Failed to look up SHERPA ROMeO result for ISSN: " + issn + ": " + response.getMessage());
                return response;
            }
            if (response.getJournals().isEmpty()) continue;
            return response;
        }
        return new SHERPAResponse();
    }

    public SHERPAResponse searchRelatedJournalsByISSN(String issn) {
        return this.sherpaService.searchByJournalISSN(issn);
    }

    public Set<String> getISSNs(Context context, Item item) {
        LinkedHashSet<String> issns = new LinkedHashSet<String>();
        if (this.configuration.getIssnItemExtractors() == null) {
            log.warn(LogHelper.getHeader(context, "searchRelatedJournals", "no issnItemExtractors defined"));
            return null;
        }
        for (ISSNItemExtractor extractor : this.configuration.getIssnItemExtractors()) {
            List<String> eIssns = extractor.getISSNs(context, item);
            if (eIssns == null) continue;
            for (String eIssn : eIssns) {
                issns.add(eIssn.trim());
            }
        }
        return issns;
    }

    public boolean hasISSNs(Context context, Item item) {
        Set<String> issns = this.getISSNs(context, item);
        return issns != null && issns.size() != 0;
    }
}

