/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa.cache;

import java.util.Objects;
import java.util.Set;
import org.dspace.app.sherpa.submit.SHERPASubmitService;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.springframework.cache.CacheManager;

public class SherpaCacheEvictService {
    static final String CACHE_NAME = "sherpa.searchByJournalISSN";
    private CacheManager cacheManager;
    private SHERPASubmitService sherpaSubmitService;

    public void evictCacheValues(Context context, Item item) {
        Set<String> ISSNs = this.sherpaSubmitService.getISSNs(context, item);
        for (String issn : ISSNs) {
            Objects.requireNonNull(this.cacheManager.getCache(CACHE_NAME)).evictIfPresent((Object)issn);
        }
    }

    public void evictAllCacheValues() {
        Objects.requireNonNull(this.cacheManager.getCache(CACHE_NAME)).invalidate();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setSherpaSubmitService(SHERPASubmitService sherpaSubmitService) {
        this.sherpaSubmitService = sherpaSubmitService;
    }
}

