/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.mediafilter.FormatFilter;
import org.dspace.app.mediafilter.SelfRegisterInputFormats;
import org.dspace.app.mediafilter.service.MediaFilterService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.SelfNamedPlugin;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.services.ConfigurationService;
import org.dspace.util.ThrowableUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class MediaFilterServiceImpl
implements MediaFilterService,
InitializingBean {
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected BitstreamFormatService bitstreamFormatService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    protected DSpaceRunnableHandler handler;
    protected int max2Process = Integer.MAX_VALUE;
    protected int processed = 0;
    protected Item currentItem = null;
    protected List<FormatFilter> filterClasses = null;
    protected Map<String, List<String>> filterFormats = new HashMap<String, List<String>>();
    protected List<String> skipList = null;
    protected final List<String> publicFiltersClasses = new ArrayList<String>();
    protected boolean isVerbose = false;
    protected boolean isQuiet = false;
    protected boolean isForce = false;

    protected MediaFilterServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        String[] publicPermissionFilters = this.configurationService.getArrayProperty("filter.org.dspace.app.mediafilter.publicPermission");
        if (publicPermissionFilters != null) {
            for (String filter : publicPermissionFilters) {
                this.publicFiltersClasses.add(filter.trim());
            }
        }
    }

    @Override
    public void applyFiltersAllItems(Context context) throws Exception {
        if (this.skipList != null) {
            List<Community> topLevelCommunities = this.communityService.findAllTop(context);
            for (Community topLevelCommunity : topLevelCommunities) {
                this.applyFiltersCommunity(context, topLevelCommunity);
            }
        } else {
            Iterator<Item> itemIterator = this.itemService.findAll(context);
            while (itemIterator.hasNext() && this.processed < this.max2Process) {
                this.applyFiltersItem(context, itemIterator.next());
            }
        }
    }

    @Override
    public void applyFiltersCommunity(Context context, Community community) throws Exception {
        if (!this.inSkipList((community = context.reloadEntity(community)).getHandle())) {
            List<Community> subcommunities = community.getSubcommunities();
            for (Community subcommunity : subcommunities) {
                this.applyFiltersCommunity(context, subcommunity);
            }
            community = context.reloadEntity(community);
            List<Collection> collections = community.getCollections();
            for (Collection collection : collections) {
                this.applyFiltersCollection(context, collection);
            }
        }
    }

    @Override
    public void applyFiltersCollection(Context context, Collection collection) throws Exception {
        if (!this.inSkipList((collection = context.reloadEntity(collection)).getHandle())) {
            Iterator<Item> itemIterator = this.itemService.findAllByCollection(context, collection);
            while (itemIterator.hasNext() && this.processed < this.max2Process) {
                this.applyFiltersItem(context, itemIterator.next());
            }
        }
    }

    @Override
    public void applyFiltersItem(Context c, Item item) throws Exception {
        if (!this.inSkipList(item.getHandle())) {
            this.currentItem = item;
            if (this.filterItem(c, item)) {
                ++this.processed;
            }
            c.uncacheEntity(this.currentItem);
            c.commit();
            this.currentItem = null;
        }
    }

    @Override
    public boolean filterItem(Context context, Item myItem) throws Exception {
        List<Bundle> myBundles = this.itemService.getBundles(myItem, "ORIGINAL");
        boolean done = false;
        for (Bundle myBundle : myBundles) {
            List<Bitstream> myBitstreams = myBundle.getBitstreams();
            for (Bitstream myBitstream : myBitstreams) {
                done |= this.filterBitstream(context, myItem, myBitstream);
            }
        }
        return done;
    }

    @Override
    public boolean filterBitstream(Context context, Item myItem, Bitstream myBitstream) throws Exception {
        boolean filtered = false;
        for (FormatFilter filterClass : this.filterClasses) {
            String[] extensions;
            String[] descriptions;
            List<String> fmts;
            String pluginName = null;
            if (SelfNamedPlugin.class.isAssignableFrom(filterClass.getClass())) {
                pluginName = ((SelfNamedPlugin)((Object)filterClass)).getPluginInstanceName();
            }
            if ((fmts = this.filterFormats.get(filterClass.getClass().getName() + (String)(pluginName != null ? "\u001c" + pluginName : ""))).contains(myBitstream.getFormat(context).getShortDescription())) {
                try {
                    if (!this.processBitstream(context, myItem, myBitstream, filterClass)) continue;
                    this.itemService.update(context, myItem);
                    filtered = true;
                }
                catch (Exception e) {
                    this.logError(this.formatBitstreamDetails(myItem.getHandle(), myBitstream));
                    this.logError(ThrowableUtils.formatCauseChain(e));
                }
                continue;
            }
            if (!(filterClass instanceof SelfRegisterInputFormats)) continue;
            SelfRegisterInputFormats srif = (SelfRegisterInputFormats)((Object)filterClass);
            boolean applyFilter = false;
            String[] mimeTypes = srif.getInputMIMETypes();
            if (mimeTypes != null) {
                for (String mimeType : mimeTypes) {
                    if (!mimeType.equalsIgnoreCase(myBitstream.getFormat(context).getMIMEType())) continue;
                    applyFilter = true;
                }
            }
            if (!applyFilter && (descriptions = srif.getInputDescriptions()) != null) {
                for (String desc : descriptions) {
                    if (!desc.equalsIgnoreCase(myBitstream.getFormat(context).getShortDescription())) continue;
                    applyFilter = true;
                }
            }
            if (!applyFilter && (extensions = srif.getInputExtensions()) != null) {
                for (String ext : extensions) {
                    List<String> formatExtensions = myBitstream.getFormat(context).getExtensions();
                    if (formatExtensions == null || !formatExtensions.contains(ext)) continue;
                    applyFilter = true;
                }
            }
            if (!applyFilter) continue;
            try {
                if (!this.processBitstream(context, myItem, myBitstream, filterClass)) continue;
                this.itemService.update(context, myItem);
                filtered = true;
            }
            catch (Exception e) {
                this.logError("ERROR filtering, skipping bitstream #" + myBitstream.getID() + " " + e);
                e.printStackTrace();
            }
        }
        return filtered;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processBitstream(Context context, Item item, Bitstream source, FormatFilter formatFilter) throws Exception {
        if (!formatFilter.preProcessBitstream(context, item, source, this.isVerbose)) {
            return false;
        }
        boolean overWrite = this.isForce;
        String newName = formatFilter.getFilteredName(source.getName());
        Bundle existingBundle = null;
        ArrayList<Bitstream> existingBitstreams = new ArrayList<Bitstream>();
        List<Bundle> bundles = this.itemService.getBundles(item, formatFilter.getBundleName());
        if (!bundles.isEmpty()) {
            for (Bundle bundle : bundles) {
                List<Bitstream> bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    if (!bitstream.getName().trim().equals(newName.trim())) continue;
                    existingBundle = bundle;
                    existingBitstreams.add(bitstream);
                }
            }
        }
        if (!overWrite && !existingBitstreams.isEmpty()) {
            if (this.isQuiet) return false;
            this.logInfo("SKIPPED: bitstream " + source.getID() + " (item: " + item.getHandle() + ") because '" + newName + "' already exists");
            return false;
        }
        if (this.isVerbose) {
            this.logInfo("PROCESSING: bitstream " + source.getID() + " (item: " + item.getHandle() + ")");
        }
        this.logInfo("File: " + newName);
        try (InputStream srcStream = this.bitstreamService.retrieve(context, source);
             InputStream destStream = formatFilter.getDestinationStream(item, srcStream, this.isVerbose);){
            if (destStream == null) {
                if (!this.isQuiet) {
                    this.logInfo("SKIPPED: bitstream " + source.getID() + " (item: " + item.getHandle() + ") because filtering was unsuccessful");
                }
                boolean bitstreams = false;
                return bitstreams;
            }
            Bundle targetBundle = bundles.isEmpty() ? this.bundleService.create(context, item, formatFilter.getBundleName()) : bundles.get(0);
            Bitstream b = this.bitstreamService.create(context, targetBundle, destStream);
            b.setName(context, newName);
            b.setSource(context, "Written by FormatFilter " + formatFilter.getClass().getName() + " on " + DCDate.getCurrent() + " (GMT).");
            b.setDescription(context, formatFilter.getDescription());
            BitstreamFormat bf = this.bitstreamFormatService.findByShortDescription(context, formatFilter.getFormatString());
            this.bitstreamService.setFormat(context, b, bf);
            this.bitstreamService.update(context, b);
            this.updatePoliciesOfDerivativeBitstream(context, b, formatFilter, source);
            formatFilter.postProcessBitstream(context, item, b);
        }
        catch (OutOfMemoryError oome) {
            this.logError("!!! OutOfMemoryError !!!");
            this.logError(this.formatBitstreamDetails(item.getHandle(), source));
        }
        Iterator<Bundle> iterator = existingBitstreams.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (this.isQuiet) return true;
                this.logInfo("FILTERED: bitstream " + source.getID() + " (item: " + item.getHandle() + ") and created '" + newName + "'");
                return true;
            }
            Bitstream existingBitstream = (Bitstream)((Object)iterator.next());
            this.bundleService.removeBitstream(context, existingBundle, existingBitstream);
        }
    }

    @Override
    public void updatePoliciesOfDerivativeBitstreams(Context context, Item item, Bitstream source) throws SQLException, AuthorizeException {
        if (this.filterClasses == null) {
            return;
        }
        for (FormatFilter formatFilter : this.filterClasses) {
            for (Bitstream bitstream : this.findDerivativeBitstreams(item, source, formatFilter)) {
                this.updatePoliciesOfDerivativeBitstream(context, bitstream, formatFilter, source);
            }
        }
    }

    private List<Bitstream> findDerivativeBitstreams(Item item, Bitstream source, FormatFilter formatFilter) throws SQLException {
        String bitstreamName = formatFilter.getFilteredName(source.getName());
        List<Bundle> bundles = this.itemService.getBundles(item, formatFilter.getBundleName());
        return bundles.stream().flatMap(bundle -> bundle.getBitstreams().stream()).filter(bitstream -> StringUtils.equals((CharSequence)bitstream.getName().trim(), (CharSequence)bitstreamName.trim())).collect(Collectors.toList());
    }

    private void updatePoliciesOfDerivativeBitstream(Context context, Bitstream bitstream, FormatFilter formatFilter, Bitstream source) throws SQLException, AuthorizeException {
        this.authorizeService.removeAllPolicies(context, bitstream);
        if (this.publicFiltersClasses.contains(formatFilter.getClass().getSimpleName())) {
            Group anonymous = this.groupService.findByName(context, "Anonymous");
            this.authorizeService.addPolicy(context, (DSpaceObject)bitstream, 0, anonymous);
        } else {
            this.authorizeService.replaceAllPolicies(context, source, bitstream);
        }
    }

    @Override
    public Item getCurrentItem() {
        return this.currentItem;
    }

    @Override
    public boolean inSkipList(String identifier) {
        if (this.skipList != null && this.skipList.contains(identifier)) {
            if (!this.isQuiet) {
                this.logInfo("SKIP-LIST: skipped bitstreams within identifier " + identifier);
            }
            return true;
        }
        return false;
    }

    private String formatBitstreamDetails(String itemHandle, Bitstream bitstream) {
        List bundles;
        try {
            bundles = bitstream.getBundles();
        }
        catch (SQLException ex) {
            this.logError("Unexpected error fetching Bundles", ex);
            bundles = Collections.EMPTY_LIST;
        }
        StringBuilder sb = new StringBuilder("ERROR filtering, skipping bitstream:\n");
        sb.append("\tItem Handle: ").append(itemHandle);
        for (Bundle bundle : bundles) {
            sb.append("\tBundle Name: ").append(bundle.getName());
        }
        sb.append("\tFile Size: ").append(bitstream.getSizeBytes());
        sb.append("\tChecksum: ").append(bitstream.getChecksum()).append(" (").append(bitstream.getChecksumAlgorithm()).append(')');
        sb.append("\tAsset Store: ").append(bitstream.getStoreNumber());
        sb.append("\tInternal ID: ").append(bitstream.getInternalId());
        return sb.toString();
    }

    private void logInfo(String message) {
        if (this.handler != null) {
            this.handler.logInfo(message);
        } else {
            System.out.println(message);
        }
    }

    private void logError(String message) {
        if (this.handler != null) {
            this.handler.logError(message);
        } else {
            System.out.println(message);
        }
    }

    private void logError(String message, Exception e) {
        if (this.handler != null) {
            this.handler.logError(message, e);
        } else {
            System.out.println(message);
        }
    }

    @Override
    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    @Override
    public void setQuiet(boolean isQuiet) {
        this.isQuiet = isQuiet;
    }

    @Override
    public void setForce(boolean isForce) {
        this.isForce = isForce;
    }

    @Override
    public void setMax2Process(int max2Process) {
        this.max2Process = max2Process;
    }

    @Override
    public void setFilterClasses(List<FormatFilter> filterClasses) {
        this.filterClasses = filterClasses;
    }

    @Override
    public void setSkipList(List<String> skipList) {
        this.skipList = skipList;
    }

    @Override
    public void setFilterFormats(Map<String, List<String>> filterFormats) {
        this.filterFormats = filterFormats;
    }

    @Override
    public void setLogHandler(DSpaceRunnableHandler handler) {
        this.handler = handler;
    }
}

