/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.itemupdate.ContentsEntry;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.MetadataUtilities;
import org.dspace.app.itemupdate.UpdateBitstreamsAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.InstallItemService;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.GroupService;

public class AddBitstreamsAction
extends UpdateBitstreamsAction {
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();

    @Override
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws IllegalArgumentException, ParseException, IOException, AuthorizeException, SQLException {
        Item item = itarch.getItem();
        File dir = itarch.getDirectory();
        List<ContentsEntry> contents = MetadataUtilities.readContentsFile(new File(dir, "contents"));
        if (contents.isEmpty()) {
            ItemUpdate.pr("Contents is empty - no bitstreams to add");
            return;
        }
        ItemUpdate.pr("Contents bitstream count: " + contents.size());
        String[] files = dir.list(ItemUpdate.fileFilter);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String filename : files) {
            fileList.add(filename);
            ItemUpdate.pr("file: " + filename);
        }
        for (ContentsEntry ce : contents) {
            if (fileList.contains(ce.filename)) continue;
            throw new IllegalArgumentException("File listed in contents is missing: " + ce.filename);
        }
        int bitstream_bundles_updated = 0;
        for (ContentsEntry ce : contents) {
            String targetBundleName = this.addBitstream(context, itarch, item, dir, ce, suppressUndo, isTest);
            if (targetBundleName.equals("") || targetBundleName.equals("THUMBNAIL") || targetBundleName.equals("TEXT")) continue;
            ++bitstream_bundles_updated;
        }
        if (this.alterProvenance && bitstream_bundles_updated > 0) {
            DtoMetadata dtom = DtoMetadata.create("dc.description.provenance", "en", "");
            String append = ". Added " + Integer.toString(bitstream_bundles_updated) + " bitstream(s) on " + DCDate.getCurrent() + " : " + this.installItemService.getBitstreamProvenanceMessage(context, item);
            MetadataUtilities.appendMetadata(context, item, dtom, false, append);
        }
    }

    protected String addBitstream(Context context, ItemArchive itarch, Item item, File dir, ContentsEntry ce, boolean suppressUndo, boolean isTest) throws IOException, IllegalArgumentException, SQLException, AuthorizeException, ParseException {
        ItemUpdate.pr("contents entry for bitstream: " + ce.toString());
        File f = new File(dir, ce.filename);
        Bitstream bs = null;
        String newBundleName = ce.bundlename;
        if (ce.bundlename == null) {
            newBundleName = ce.filename.equals("license.txt") ? "LICENSE" : "ORIGINAL";
        }
        ItemUpdate.pr("  Bitstream " + ce.filename + " to be added to bundle: " + newBundleName);
        if (!isTest) {
            Group group;
            List<Bundle> bundles = itemService.getBundles(item, newBundleName);
            Bundle targetBundle = null;
            if (bundles.size() < 1) {
                targetBundle = this.bundleService.create(context, item, newBundleName);
            } else {
                for (Bundle b : bundles) {
                    List<Bitstream> bitstreams = b.getBitstreams();
                    for (Bitstream bsm : bitstreams) {
                        if (!bsm.getName().equals(ce.filename)) continue;
                        throw new IllegalArgumentException("Duplicate bundle + filename cannot be added: " + b.getName() + " + " + bsm.getName());
                    }
                }
                targetBundle = bundles.iterator().next();
            }
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
                bs = this.bitstreamService.create(context, targetBundle, bis);
            }
            bs.setName(context, ce.filename);
            BitstreamFormat fmt = this.bitstreamFormatService.guessFormat(context, bs);
            this.bitstreamService.setFormat(context, bs, fmt);
            if (ce.description != null) {
                bs.setDescription(context, ce.description);
            }
            if (ce.permissionsActionId != -1 && ce.permissionsGroupName != null && (group = this.groupService.findByName(context, ce.permissionsGroupName)) != null) {
                this.authorizeService.removeAllPolicies(context, bs);
                this.authorizeService.createResourcePolicy(context, bs, group, null, ce.permissionsActionId, null);
            }
            this.bitstreamService.update(context, bs);
            if (!suppressUndo) {
                itarch.addUndoDeleteContents(bs.getID());
            }
            return targetBundle.getName();
        }
        return "";
    }
}

