/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class BatchUpload {
    private Date date;
    private File dir;
    private boolean successful;
    private int itemsImported;
    private int totalItems = 0;
    private List<String> handlesImported = new ArrayList<String>();
    private String errorMsg = "";
    private String errorMsgHTML = "";

    public BatchUpload(String dirPath) {
        this.initializeWithFile(new File(dirPath));
    }

    public BatchUpload(File dir) {
        this.initializeWithFile(dir);
    }

    private void initializeWithFile(File dir) {
        this.dir = dir;
        String dirName = dir.getName();
        long timeMillis = Long.parseLong(dirName);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(timeMillis);
        this.date = calendar.getTime();
        try {
            this.itemsImported = this.countLines(dir + File.separator + "mapfile");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.totalItems = file.list().length;
        }
        this.successful = this.totalItems == this.itemsImported;
        File errorFile = new File(dir + File.separator + "error.txt");
        if (errorFile.exists()) {
            try {
                this.readFile(dir + File.separator + "error.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int countLines(String filename) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        int cnt = 0;
        String lineRead = "";
        while ((lineRead = reader.readLine()) != null) {
            String[] parts = lineRead.split(" ");
            if (parts.length > 1) {
                this.handlesImported.add(parts[1].trim());
                continue;
            }
            this.handlesImported.add(lineRead);
        }
        cnt = reader.getLineNumber();
        reader.close();
        return cnt;
    }

    private void readFile(String filename) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        String lineRead = "";
        while ((lineRead = reader.readLine()) != null) {
            this.errorMsg = this.errorMsg + lineRead + "\n";
            if (lineRead.startsWith("\tat ")) {
                this.errorMsgHTML = this.errorMsgHTML + "<span class=\"batchimport-error-tab\">" + lineRead + "</span><br/>";
                continue;
            }
            if (lineRead.startsWith("Caused by")) {
                this.errorMsgHTML = this.errorMsgHTML + "<span class=\"batchimport-error-caused\">" + lineRead + "</span><br/>";
                continue;
            }
            this.errorMsgHTML = this.errorMsgHTML + lineRead + "<br/>";
        }
        reader.close();
    }

    public Date getDate() {
        return this.date;
    }

    public File getDir() {
        return this.dir;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public int getItemsImported() {
        return this.itemsImported;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public String getDateFormatted() {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy - HH:mm");
        return df.format(this.date);
    }

    public List<String> getHandlesImported() {
        return this.handlesImported;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorMsgHTML() {
        return this.errorMsgHTML;
    }
}

