/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkaccesscontrol;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.cli.Options;
import org.dspace.app.bulkaccesscontrol.BulkAccessControl;
import org.dspace.app.util.DSpaceObjectUtilsImpl;
import org.dspace.app.util.service.DSpaceObjectUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.utils.DSpace;

public class BulkAccessControlScriptConfiguration<T extends BulkAccessControl>
extends ScriptConfiguration<T> {
    private Class<T> dspaceRunnableClass;

    @Override
    public boolean isAllowedToExecute(Context context, List<DSpaceCommandLineParameter> commandLineParameters) {
        try {
            if (Objects.isNull(commandLineParameters)) {
                return this.authorizeService.isAdmin(context) || this.authorizeService.isComColAdmin(context) || this.authorizeService.isItemAdmin(context);
            }
            List dspaceObjectIDs = commandLineParameters.stream().filter(parameter -> "-u".equals(parameter.getName())).map(DSpaceCommandLineParameter::getValue).collect(Collectors.toList());
            DSpaceObjectUtils dSpaceObjectUtils = (DSpaceObjectUtils)new DSpace().getServiceManager().getServiceByName(DSpaceObjectUtilsImpl.class.getName(), DSpaceObjectUtilsImpl.class);
            for (String dspaceObjectID : dspaceObjectIDs) {
                DSpaceObject dso = dSpaceObjectUtils.findDSpaceObject(context, UUID.fromString(dspaceObjectID));
                if (Objects.isNull(dso)) {
                    throw new IllegalArgumentException();
                }
                if (this.authorizeService.isAdmin(context, dso)) continue;
                return false;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("u", "uuid", true, "target uuids of communities/collections/items");
            options.getOption("u").setType(String.class);
            options.getOption("u").setRequired(true);
            options.addOption("f", "file", true, "source json file");
            options.getOption("f").setType(InputStream.class);
            options.getOption("f").setRequired(true);
            options.addOption("h", "help", false, "help");
            this.options = options;
        }
        return this.options;
    }

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }
}

