/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.builder.VerifierKnowledgeBaseBuilder;
import org.drools.verifier.builder.VerifierPackageBuilder;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;
import org.drools.verifier.visitor.PackageDescrVisitor;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.builder.KnowledgeBuilderError;

public class VerifierImpl
implements Verifier {
    private KieBase verifierKnowledgeBase;
    private KieSession ksession;
    private final VerifierConfiguration conf;
    private List<VerifierError> errors = new ArrayList<VerifierError>();
    private VerifierReport result = VerifierReportFactory.newVerifierReport();
    private List<JarInputStream> jars = new ArrayList<JarInputStream>();
    private VerifierPackageBuilder verifierPackageBuilder = new VerifierPackageBuilder();

    public VerifierImpl(VerifierConfiguration conf) {
        this.conf = conf;
    }

    public VerifierImpl() {
        this.conf = new DefaultVerifierConfiguration();
    }

    public KieSession getKnowledgeSession() {
        return this.ksession;
    }

    public void addPackageDescr(PackageDescr descr) {
        try {
            PackageDescrVisitor ruleFlattener = new PackageDescrVisitor(this.result.getVerifierData(), this.jars);
            ruleFlattener.visitPackageDescr(descr);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void addObjectModel(JarInputStream jar) {
        this.jars.add(jar);
    }

    public synchronized void reloadVerifierKnowledgeBase() throws Exception {
        this.updateRuleBase();
    }

    @Override
    public boolean fireAnalysis() {
        return this.analyse(new ScopesAgendaFilter(true, ScopesAgendaFilter.ALL_SCOPES));
    }

    @Override
    public boolean fireAnalysis(ScopesAgendaFilter scopesAgendaFilter) {
        return this.analyse(scopesAgendaFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyse(ScopesAgendaFilter scopesAgendaFilter) {
        try {
            if (this.verifierKnowledgeBase == null) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    this.updateRuleBase();
                    this.updateKnowledgeSession();
                }
            }
            for (Object e : this.result.getVerifierData().getAll()) {
                this.ksession.insert(e);
            }
            this.ksession.setGlobal("result", (Object)this.result);
            this.ksession.fireAllRules((AgendaFilter)scopesAgendaFilter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void flushKnowledgeSession() {
        this.updateKnowledgeSession();
    }

    private void updateKnowledgeSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        this.ksession = this.verifierKnowledgeBase.newKieSession();
    }

    @Override
    public VerifierReport getResult() {
        return this.result;
    }

    private void updateRuleBase() {
        VerifierKnowledgeBaseBuilder verifierKnowledgeBaseBuilder = new VerifierKnowledgeBaseBuilder();
        this.verifierKnowledgeBase = verifierKnowledgeBaseBuilder.newVerifierKnowledgeBase(this.conf);
        if (verifierKnowledgeBaseBuilder.hasErrors()) {
            this.errors.addAll(verifierKnowledgeBaseBuilder.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.ksession != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.ksession.dispose();
            }
        }
    }

    @Override
    public void addResourcesToVerify(Resource resource, ResourceType type, ResourceConfiguration config) {
        PackageDescr pkg;
        this.verifierPackageBuilder.addKnowledgeResource(resource, type, config);
        if (this.verifierPackageBuilder.hasErrors()) {
            this.addVerifierErrors(this.verifierPackageBuilder.getErrors());
        }
        if ((pkg = this.verifierPackageBuilder.getPackageDescr()) != null) {
            this.addPackageDescr(pkg);
        } else {
            this.errors.add(new VerifierError("Verifier could not form a PackageDescr from the resources that it was trying to verify."));
        }
    }

    @Override
    public void addResourcesToVerify(Resource resource, ResourceType type) {
        PackageDescr pkg;
        this.verifierPackageBuilder.addKnowledgeResource(resource, type, null);
        if (this.verifierPackageBuilder.hasErrors()) {
            this.addVerifierErrors(this.verifierPackageBuilder.getErrors());
        }
        if ((pkg = this.verifierPackageBuilder.getPackageDescr()) != null) {
            this.addPackageDescr(pkg);
        } else {
            this.errors.add(new VerifierError("Verifier could not form a PackageDescr from the resources that it was trying to verify."));
        }
    }

    private void addVerifierErrors(PackageBuilderErrors packageBuilderErrors) {
        for (KnowledgeBuilderError knowledgeBuilderError : packageBuilderErrors) {
            this.errors.add(new VerifierError(knowledgeBuilderError.getMessage()));
        }
    }

    private void addDrlData(String drl) {
        List<DrlRuleParser> rules;
        try {
            DrlPackageParser pData = this.addDrlPackageData(drl);
            rules = pData.getRules();
        }
        catch (ParseException e) {
            rules = DrlRuleParser.findRulesDataFromDrl(drl);
        }
        this.addDrlRulesData(rules);
    }

    private void addDrlRulesData(List<DrlRuleParser> rules) {
        for (DrlRuleParser rData : rules) {
            VerifierRule rule = this.result.getVerifierData().getRuleByName(rData.getName());
            if (rule == null) continue;
            rule.getHeader().addAll(rData.getHeader());
            rule.getLhsRows().addAll(rData.getLhs());
            rule.getRhsRows().addAll(rData.getRhs());
            rule.setDescription(rData.getDescription());
            rule.getCommentMetadata().addAll(rData.getMetadata());
            rule.getOtherInfo().putAll(rData.getOtherInformation());
        }
    }

    private DrlPackageParser addDrlPackageData(String drl) throws ParseException {
        DrlPackageParser pData = DrlPackageParser.findPackageDataFromDrl(drl);
        RulePackage rPackage = this.result.getVerifierData().getPackageByName(pData.getName());
        rPackage.getGlobals().addAll(pData.getGlobals());
        rPackage.setDescription(pData.getDescription());
        rPackage.getMetadata().addAll(pData.getMetadata());
        rPackage.getOtherInfo().putAll(pData.getOtherInformation());
        return pData;
    }

    @Override
    public List<VerifierError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

