/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarInputStream;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.jarloader.PackageHeaderLoader;
import org.drools.verifier.visitor.ObjectTypeFactory;
import org.drools.verifier.visitor.RuleDescrVisitor;
import org.drools.verifier.visitor.TypeDeclarationDescrVisitor;
import org.drools.verifier.visitor.UnknownDescriptionException;

public class PackageDescrVisitor {
    private final VerifierData data;
    private List<JarInputStream> jars = null;
    private RulePackage rulePackage;

    public PackageDescrVisitor(VerifierData data, List<JarInputStream> jars) {
        this.data = data;
        this.jars = jars;
    }

    public void visitPackageDescr(PackageDescr descr) throws UnknownDescriptionException, ClassNotFoundException, IOException {
        this.rulePackage = this.data.getPackageByName(descr.getName());
        if (this.rulePackage == null) {
            this.rulePackage = new RulePackage(descr);
            this.rulePackage.setName(descr.getName());
            this.data.add(this.rulePackage);
        }
        this.visitImports(descr.getImports());
        TypeDeclarationDescrVisitor typeDeclarationDescrVisitor = new TypeDeclarationDescrVisitor(this.data);
        typeDeclarationDescrVisitor.visit(descr.getTypeDeclarations());
        this.visitRules(descr.getRules());
    }

    private void visitImports(List<ImportDescr> importDescrs) throws IOException, ClassNotFoundException {
        String name;
        HashSet<String> imports = new HashSet<String>();
        for (ImportDescr i : importDescrs) {
            String fullName = i.getTarget();
            name = fullName.substring(fullName.lastIndexOf(".") + 1);
            imports.add(fullName);
            Import objectImport = new Import(i, this.rulePackage);
            objectImport.setName(fullName);
            objectImport.setShortName(name);
            this.data.add(objectImport);
            ObjectType objectType = this.data.getObjectTypeByFullName(fullName);
            if (objectType == null) {
                objectType = new ObjectType((BaseDescr)i);
            }
            objectType.setName(name);
            objectType.setFullName(fullName);
            this.data.add(objectType);
        }
        PackageHeaderLoader packageHeaderLoader = new PackageHeaderLoader(imports, this.jars);
        for (String factTypeName : packageHeaderLoader.getClassNames()) {
            name = factTypeName.substring(factTypeName.lastIndexOf(".") + 1);
            Collection<String> fieldNames = packageHeaderLoader.getFieldNames(factTypeName);
            for (String fieldName : fieldNames) {
                ObjectType objectType = this.data.getObjectTypeByObjectTypeNameAndPackageName(name, this.rulePackage.getName());
                Field field = this.data.getFieldByObjectTypeAndFieldName(objectType.getFullName(), fieldName);
                if (field != null) continue;
                field = ObjectTypeFactory.createField(objectType.getDescr(), fieldName, objectType);
                field.setFieldType(packageHeaderLoader.getFieldType(objectType.getName(), fieldName));
                this.data.add(field);
            }
        }
    }

    private void visitRules(List<RuleDescr> rules) throws UnknownDescriptionException {
        for (RuleDescr ruleDescr : rules) {
            this.visitRuleDescr(ruleDescr);
        }
    }

    private void visitRuleDescr(RuleDescr descr) throws UnknownDescriptionException {
        RuleDescrVisitor visitor = new RuleDescrVisitor(this.data, this.rulePackage);
        visitor.visitRuleDescr(descr);
    }
}

