/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.drools.lang.descr.BaseDescr;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.VerifierComponentType;
import org.drools.verifier.data.VerifierComponent;

public class ObjectType
extends VerifierComponent<BaseDescr>
implements Serializable {
    private static final long serialVersionUID = 510L;
    private int offset = 0;
    private String fullName;
    private String name;
    private Set<Field> fields = new HashSet<Field>();
    private Multimap<String, String> metadata = TreeMultimap.create();

    public ObjectType(BaseDescr descr) {
        super(descr);
    }

    public int getOffset() {
        ++this.offset;
        return this.offset % 2;
    }

    @Override
    public String getPath() {
        return String.format("objectType[@name='%s']", this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Field> getFields() {
        return this.fields;
    }

    public void setFields(Set<Field> fields) {
        this.fields = fields;
    }

    @Override
    public VerifierComponentType getVerifierComponentType() {
        return VerifierComponentType.OBJECT_TYPE;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String toString() {
        return "ObjectType: " + this.fullName;
    }

    public Multimap<String, String> getMetadata() {
        return this.metadata;
    }
}

