/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderConfiguration;
import org.kie.builder.KnowledgeBuilderError;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.io.Resource;

public class VerifierKnowledgeBaseBuilder {
    private List<VerifierError> errors = new ArrayList<VerifierError>();

    public KnowledgeBase newVerifierKnowledgeBase(VerifierConfiguration configuration) {
        KnowledgeBase verifierKnowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilderConfiguration kbuilderConfiguration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbuilderConfiguration.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConfiguration);
        if (configuration.getVerifyingResources() != null) {
            for (Resource resource : configuration.getVerifyingResources().keySet()) {
                kbuilder.add(resource, configuration.getVerifyingResources().get(resource));
            }
        }
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                this.errors.add(new VerifierError("Error compiling verifier rules: " + ((KnowledgeBuilderError)errors.next()).getMessage()));
            }
        }
        verifierKnowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return verifierKnowledgeBase;
    }

    public List<VerifierError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

