/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.solver;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.verifier.components.OperatorDescrType;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternComponent;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.SubPattern;
import org.drools.verifier.components.SubRule;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.solver.PatternSolver;
import org.drools.verifier.solver.RuleSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solvers {
    private RuleSolver ruleSolver = null;
    private PatternSolver patternSolver = null;
    private List<SubPattern> subPatterns = new ArrayList<SubPattern>();
    private List<SubRule> rulePossibilities = new ArrayList<SubRule>();
    private int subRuleIndex = 0;
    private int subPatternIndex = 0;

    public void startRuleSolver(VerifierRule rule) {
        this.ruleSolver = new RuleSolver(rule);
    }

    public void endRuleSolver() {
        this.createRulePossibilities();
        this.ruleSolver = null;
    }

    public void startPatternSolver(Pattern pattern) {
        this.patternSolver = new PatternSolver(pattern);
        this.patternSolver.getPattern().setPatternNot(this.ruleSolver.isChildNot());
    }

    public void endPatternSolver() {
        this.createPatternPossibilities();
        this.patternSolver = null;
    }

    public void startForall() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildForall(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildForall(true);
        }
    }

    public void endForall() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildForall(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildForall(false);
        }
    }

    public void startExists() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildExists(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildExists(true);
        }
    }

    public void endExists() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildExists(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildExists(false);
        }
    }

    public void startNot() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildNot(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildNot(true);
        }
    }

    public void endNot() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildNot(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildNot(false);
        }
    }

    public void startOperator(OperatorDescrType type) {
        if (this.patternSolver != null) {
            this.patternSolver.addOperator(type);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.addOperator(type);
        }
    }

    public void endOperator() {
        if (this.patternSolver != null) {
            this.patternSolver.end();
        } else if (this.ruleSolver != null) {
            this.ruleSolver.end();
        }
    }

    public void addRuleComponent(RuleComponent ruleComponent) {
        this.ruleSolver.add(ruleComponent);
    }

    public void addPatternComponent(PatternComponent patternComponent) {
        this.patternSolver.add(patternComponent);
    }

    private void createPatternPossibilities() {
        List<Set<VerifierComponent>> lists = this.patternSolver.getPossibilityLists();
        if (lists.size() == 0) {
            SubPattern subPattern = this.newSubPattern();
            this.ruleSolver.add(subPattern);
            this.subPatterns.add(subPattern);
        } else {
            for (Set<VerifierComponent> list : lists) {
                SubPattern subPattern = this.newSubPattern();
                for (VerifierComponent descr : list) {
                    subPattern.add((PatternComponent)descr);
                }
                this.ruleSolver.add(subPattern);
                this.subPatterns.add(subPattern);
            }
        }
    }

    private SubPattern newSubPattern() {
        SubPattern subPattern = new SubPattern(this.patternSolver.getPattern(), this.subPatternIndex++);
        return subPattern;
    }

    private void createRulePossibilities() {
        for (Set<VerifierComponent> list : this.ruleSolver.getPossibilityLists()) {
            SubRule possibility = new SubRule(this.ruleSolver.getRule(), this.subRuleIndex++);
            for (VerifierComponent descr : list) {
                possibility.add((RuleComponent)descr);
            }
            this.rulePossibilities.add(possibility);
        }
    }

    public List<SubPattern> getPatternPossibilities() {
        return this.subPatterns;
    }

    public void setPatternPossibilities(List<SubPattern> patternPossibilities) {
        this.subPatterns = patternPossibilities;
    }

    public List<SubRule> getRulePossibilities() {
        return this.rulePossibilities;
    }

    public void setRulePossibilities(List<SubRule> rulePossibilities) {
        this.rulePossibilities = rulePossibilities;
    }

    public PatternSolver getPatternSolver() {
        return this.patternSolver;
    }

    public RuleSolver getRuleSolver() {
        return this.ruleSolver;
    }
}

