/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.io.Resource;
import org.drools.lang.descr.PackageDescr;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.AgendaFilter;
import org.drools.verifier.DefaultVerifierConfiguration;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierConfiguration;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.MetaDataAgendaFilter;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.data.VerifierComponent;
import org.drools.verifier.data.VerifierReport;
import org.drools.verifier.data.VerifierReportFactory;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;
import org.drools.verifier.visitor.PackageDescrVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierImpl
implements Verifier {
    private KnowledgeBase verifierKnowledgeBase;
    private StatefulKnowledgeSession ksession;
    private final VerifierConfiguration conf;
    private List<VerifierError> errors = new ArrayList<VerifierError>();
    private VerifierReport result = VerifierReportFactory.newVerifierReport();
    private List<JarInputStream> jars = new ArrayList<JarInputStream>();

    public VerifierImpl(VerifierConfiguration conf) {
        this.conf = conf;
    }

    public VerifierImpl() {
        this.conf = new DefaultVerifierConfiguration();
    }

    public StatefulKnowledgeSession getKnowledgeSession() {
        return this.ksession;
    }

    public void addPackageDescr(PackageDescr descr) {
        try {
            PackageDescrVisitor ruleFlattener = new PackageDescrVisitor(this.result.getVerifierData(), this.jars);
            ruleFlattener.visitPackageDescr(descr);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void addObjectModel(JarInputStream jar) {
        this.jars.add(jar);
    }

    public synchronized void reloadVerifierKnowledgeBase() throws Exception {
        this.updateRuleBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fireAnalysis() {
        try {
            if (this.verifierKnowledgeBase == null) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    this.updateRuleBase();
                    this.updateKnowledgeSession();
                }
            }
            for (VerifierComponent o : this.result.getVerifierData().getAll()) {
                this.ksession.insert((Object)o);
            }
            this.ksession.setGlobal("result", (Object)this.result);
            this.ksession.fireAllRules((AgendaFilter)new MetaDataAgendaFilter(this.conf.acceptRulesWithoutVerifiyingScope(), "verifying_scopes", this.conf.getVerifyingScopes()));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateKnowledgeSession() {
        if (this.ksession != null) {
            this.ksession.dispose();
        }
        this.ksession = this.verifierKnowledgeBase.newStatefulKnowledgeSession();
    }

    @Override
    public VerifierReport getResult() {
        return this.result;
    }

    private void updateRuleBase() throws Exception {
        this.verifierKnowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilderConfiguration kbuilderConfiguration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbuilderConfiguration.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConfiguration);
        if (this.conf.getVerifyingResources() != null) {
            for (Resource resource : this.conf.getVerifyingResources().keySet()) {
                kbuilder.add(resource, this.conf.getVerifyingResources().get(resource));
            }
        }
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                this.errors.add(new VerifierError("Error compiling verifier rules: " + ((KnowledgeBuilderError)errors.next()).getMessage()));
            }
            throw new IllegalStateException("Error compiling verifier rules");
        }
        this.verifierKnowledgeBase.addKnowledgePackages(kbuilder.getKnowledgePackages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.ksession != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.ksession.dispose();
            }
        }
    }

    @Override
    public void addResourcesToVerify(Resource resource, ResourceType type) {
        if (type.matchesExtension(".drl")) {
            DrlParser drlParser = new DrlParser();
            try {
                BufferedReader reader = new BufferedReader(resource.getReader());
                StringBuffer drl = new StringBuffer("");
                String line = null;
                do {
                    if ((line = reader.readLine()) == null) continue;
                    drl.append(line);
                    drl.append("\n");
                } while (line != null);
                PackageDescr pkg = drlParser.parse(drl.toString());
                if (drlParser.hasErrors()) {
                    this.addVerifierErrors(drlParser);
                } else if (pkg == null) {
                    this.errors.add(new VerifierError("Verifier could not form a PackageDescr from the resources that it was trying to verify."));
                } else {
                    this.addPackageDescr(pkg);
                    this.addDrlData(drl.toString());
                }
                reader.close();
            }
            catch (DroolsParserException e) {
                this.errors.add(new VerifierError(e.getMessage()));
            }
            catch (IOException e) {
                this.errors.add(new VerifierError(e.getMessage()));
            }
        }
    }

    private void addVerifierErrors(DrlParser p) {
        for (DroolsError droolsError : p.getErrors()) {
            this.errors.add(new VerifierError(droolsError.getMessage()));
        }
    }

    private void addDrlData(String drl) {
        List<DrlRuleParser> rules;
        try {
            DrlPackageParser pData = this.addDrlPackageData(drl);
            rules = pData.getRules();
        }
        catch (ParseException e) {
            rules = DrlRuleParser.findRulesDataFromDrl(drl);
        }
        this.addDrlRulesData(rules);
    }

    private void addDrlRulesData(List<DrlRuleParser> rules) {
        for (DrlRuleParser rData : rules) {
            VerifierRule rule = this.result.getVerifierData().getRuleByName(rData.getName());
            if (rule == null) continue;
            rule.getHeader().addAll(rData.getHeader());
            rule.getLhsRows().addAll(rData.getLhs());
            rule.getRhsRows().addAll(rData.getRhs());
            rule.setDescription(rData.getDescription());
            rule.getCommentMetadata().addAll(rData.getMetadata());
            rule.getOtherInfo().putAll(rData.getOtherInformation());
        }
    }

    private DrlPackageParser addDrlPackageData(String drl) throws ParseException {
        DrlPackageParser pData = DrlPackageParser.findPackageDataFromDrl(drl);
        RulePackage rPackage = this.result.getVerifierData().getPackageByName(pData.getName());
        rPackage.getGlobals().addAll(pData.getGlobals());
        rPackage.setDescription(pData.getDescription());
        rPackage.getMetadata().addAll(pData.getMetadata());
        rPackage.getOtherInfo().putAll(pData.getOtherInformation());
        return pData;
    }

    @Override
    public List<VerifierError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

