/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.drools.verifier.dao.DataTree;
import org.drools.verifier.dao.VerifierData;
import org.drools.verifier.dao.VerifierDataMaps;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.report.components.Gap;
import org.drools.verifier.report.components.MissingNumberPattern;
import org.drools.verifier.report.components.RangeCheckCause;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.components.VerifierMessageBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifierResultNormal
implements VerifierResult {
    private static final long serialVersionUID = -6207688526236713721L;
    private Map<Integer, Gap> gapsById = new TreeMap<Integer, Gap>();
    private DataTree<Integer, Gap> gapsByFieldId = new DataTree();
    private Map<Integer, MissingNumberPattern> missingNumberPatternsById = new TreeMap<Integer, MissingNumberPattern>();
    private DataTree<Integer, MissingNumberPattern> missingNumberPatternsByFieldId = new DataTree();
    private List<VerifierMessageBase> messages = new ArrayList<VerifierMessageBase>();
    private DataTree<Severity, VerifierMessageBase> messagesBySeverity = new DataTree();
    private VerifierData data = new VerifierDataMaps();

    VerifierResultNormal() {
    }

    @Override
    public void add(VerifierMessageBase message) {
        this.messages.add(message);
        this.messagesBySeverity.put(message.getSeverity(), message);
    }

    @Override
    public Collection<VerifierMessageBase> getBySeverity(Severity severity) {
        Set<VerifierMessageBase> result = this.messagesBySeverity.getBranch(severity);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public void add(Gap gap) {
        this.gapsById.put(gap.getId(), gap);
        this.gapsByFieldId.put(gap.getField().getId(), gap);
    }

    @Override
    public void remove(Gap gap) {
        this.gapsById.remove(gap.getId());
        this.gapsByFieldId.remove(gap.getField().getId(), gap);
    }

    @Override
    public Collection<Gap> getGapsByFieldId(int fieldId) {
        return this.gapsByFieldId.getBranch(fieldId);
    }

    @Override
    public Collection<RangeCheckCause> getRangeCheckCauses() {
        ArrayList<RangeCheckCause> result = new ArrayList<RangeCheckCause>();
        result.addAll(this.gapsById.values());
        result.addAll(this.missingNumberPatternsById.values());
        return result;
    }

    @Override
    public void add(MissingNumberPattern missingNumberPattern) {
        this.missingNumberPatternsById.put(missingNumberPattern.getId(), missingNumberPattern);
        this.missingNumberPatternsByFieldId.put(missingNumberPattern.getField().getId(), missingNumberPattern);
    }

    @Override
    public Collection<RangeCheckCause> getRangeCheckCausesByFieldId(int id) {
        ArrayList<RangeCheckCause> result = new ArrayList<RangeCheckCause>();
        result.addAll(this.gapsByFieldId.getBranch(id));
        result.addAll(this.missingNumberPatternsByFieldId.getBranch(id));
        return result;
    }

    @Override
    public VerifierData getVerifierData() {
        return this.data;
    }
}

