/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.doc;

import java.io.OutputStream;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.drools.util.Config;
import org.drools.verifier.doc.DroolsDocsComponentFactory;
import org.drools.verifier.misc.DrlPackageParser;
import org.drools.verifier.misc.DrlRuleParser;

public class DroolsDocsBuilder {
    protected final String currentDate = DroolsDocsBuilder.getFormatter().format(new Date());
    private final DrlPackageParser packageData;

    protected static Format getFormatter() {
        return new SimpleDateFormat(DroolsDocsBuilder.getDateFormatMask());
    }

    public DroolsDocsBuilder(String packageDrl) throws ParseException {
        this.packageData = DrlPackageParser.findPackageDataFromDrl(packageDrl);
    }

    protected DroolsDocsBuilder(DrlPackageParser packageData) {
        this.packageData = packageData;
    }

    public static DroolsDocsBuilder getInstance(String packageDrl) throws ParseException {
        return new DroolsDocsBuilder(packageDrl);
    }

    public static DroolsDocsBuilder getInstance(DrlPackageParser packageData) {
        return new DroolsDocsBuilder(packageData);
    }

    public void writePDF(OutputStream out) {
        try (PDDocument doc = new PDDocument();){
            PDDocumentInformation info = new PDDocumentInformation();
            info.setTitle(this.packageData.getName().toUpperCase());
            doc.setDocumentInformation(info);
            DroolsDocsComponentFactory.createFirstPage(doc, this.currentDate, this.packageData);
            int pageNumber = 2;
            DroolsDocsComponentFactory.createToC(doc, pageNumber, this.packageData);
            for (DrlRuleParser ruleData : this.packageData.getRules()) {
                DroolsDocsComponentFactory.createRulePage(doc, ++pageNumber, this.packageData.getName(), ruleData);
            }
            doc.save(out);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static String getDateFormatMask() {
        String fmt = Config.getConfig((String)"drools.dateformat");
        if (fmt == null) {
            fmt = "dd-MMM-yyyy";
        }
        return fmt;
    }
}

