/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.drools.util.IoUtils;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ReportVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ReportVisitor.class);

    ReportVisitor() {
    }

    protected static String processHeader(String folder) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sourceFolder", folder);
        map.put("objectTypesFile", "index.htm");
        map.put("packagesFile", "packages.htm");
        map.put("messagesFile", "verifierMessages.htm");
        String myTemplate = ReportVisitor.readFile("header.htm");
        return String.valueOf(TemplateRuntime.eval((String)myTemplate, map));
    }

    protected static String readFile(String fileName) {
        StringBuilder str = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ReportVisitor.class.getResourceAsStream(fileName), IoUtils.UTF8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                str.append(line);
                str.append("\n");
            }
        }
        catch (IOException e) {
            LOG.error("Exception", (Throwable)e);
        }
        catch (NullPointerException e) {
            System.err.println("File " + fileName + " was not found.");
            LOG.error("Exception", (Throwable)e);
        }
        return str.toString();
    }

    protected static String createStyleTag(String path) {
        StringBuilder str = new StringBuilder();
        str.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        str.append(path);
        str.append("\" />");
        return str.toString();
    }
}

