/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Multimap<K, V> {
    private final Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();

    public Collection<V> get(K key) {
        return this.map.getOrDefault(key, Collections.emptyList());
    }

    public void put(K key, V value) {
        this.map.computeIfAbsent(key, K -> new ArrayList()).add(value);
    }

    public void remove(K key, V value) {
        Collection<V> values = this.map.get(key);
        if (values != null) {
            values.remove(value);
        }
    }

    public Iterable<V> values() {
        return this.map.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }
}

