/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.jarloader;

import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import org.drools.mvel.asm.ClassFieldInspectorImpl;
import org.drools.util.ClassTypeResolver;
import org.drools.verifier.jarloader.VerifierMapBackedClassLoader;

public class PackageHeaderLoader {
    private static final Collection<String> IGNORED_FIELDS = PackageHeaderLoader.getIgnoredFields();
    private Set<String> classNames = new HashSet<String>();
    private Map<String, String> fieldTypesByClassAndFieldNames = new HashMap<String, String>();
    private TreeMultimap<String, String> fieldsByClassNames = TreeMultimap.create();
    private List<String> missingClasses = new ArrayList<String>();

    public PackageHeaderLoader(Collection<String> imports, List<JarInputStream> jarInputStreams) throws IOException {
        this.findImportsFromJars(imports, jarInputStreams);
    }

    private void findImportsFromJars(Collection<String> imports, List<JarInputStream> jarInputStreams) throws IOException {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), (ClassLoader)((Object)new VerifierMapBackedClassLoader(jarInputStreams)));
        for (String className : imports) {
            this.classNames.add(className);
            try {
                Class clazz = resolver.resolveType(className);
                this.addFields(clazz);
            }
            catch (ClassNotFoundException e) {
                this.missingClasses.add(className);
            }
        }
    }

    private void addFields(Class clazz) throws IOException {
        String className = clazz.getName();
        ClassFieldInspectorImpl inspector = new ClassFieldInspectorImpl(clazz);
        Set fieldNames = inspector.getFieldNames().keySet();
        Map fieldTypes = inspector.getFieldTypes();
        this.addThisField(className);
        for (String field : fieldNames) {
            if (IGNORED_FIELDS.contains(field)) continue;
            this.fieldsByClassNames.put((Object)className, (Object)field);
            this.fieldTypesByClassAndFieldNames.put(className + "." + field, ((Class)fieldTypes.get(field)).getName());
        }
    }

    private void addThisField(String className) {
        this.fieldsByClassNames.put((Object)className, (Object)"this");
        this.fieldTypesByClassAndFieldNames.put(className + ".this", className);
    }

    public Collection<String> getClassNames() {
        return this.classNames;
    }

    public Collection<String> getFieldNames(String className) {
        return this.fieldsByClassNames.get((Object)className);
    }

    public String getFieldType(String className, String fieldName) {
        return this.fieldTypesByClassAndFieldNames.get(className + "." + fieldName);
    }

    public Collection<String> getMissingClasses() {
        return this.missingClasses;
    }

    private static Collection<String> getIgnoredFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("toString");
        fields.add("hashCode");
        fields.add("class");
        return fields;
    }
}

