/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.zip.ZipOutputStream;
import org.drools.util.IoUtils;
import org.drools.verifier.report.html.HTMLReportWriter;
import org.drools.verifier.report.html.ReportVisitor;
import org.drools.verifier.report.html.VerifierMessagesVisitor;
import org.mvel2.templates.TemplateRuntime;

abstract class ReportModeller {
    protected ZipOutputStream zout;

    ReportModeller() {
    }

    protected String formPage(String sourceFolder, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        String myTemplate = VerifierMessagesVisitor.readFile("frame.htm");
        map.put("cssStyle", ReportVisitor.createStyleTag(sourceFolder + "/" + "css" + "/" + "basic.css"));
        map.put("sourceFolder", sourceFolder);
        map.put("header", ReportVisitor.processHeader(sourceFolder));
        map.put("content", content);
        return String.valueOf(TemplateRuntime.eval((String)myTemplate, map));
    }

    public void copyFile(String destination, String filename) throws IOException {
        int len;
        this.zout.putNextEntry(new JarEntry(destination + "/" + filename));
        InputStream in = HTMLReportWriter.class.getResourceAsStream(filename);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            this.zout.write(buf, 0, len);
        }
        in.close();
        this.zout.closeEntry();
    }

    protected void writeToFile(String fileName, String text) throws IOException {
        this.zout.putNextEntry(new JarEntry(fileName));
        ByteArrayInputStream i = new ByteArrayInputStream(text.getBytes(IoUtils.UTF8_CHARSET));
        int len = 0;
        byte[] copyBuf = new byte[1024];
        while (len != -1) {
            len = i.read(copyBuf, 0, copyBuf.length);
            if (len <= 0) continue;
            this.zout.write(copyBuf, 0, len);
        }
        i.close();
        this.zout.closeEntry();
    }
}

